///////////////////////////////////////////////////////////////////////////////
//
//  AutobahnJS - http://autobahn.ws, http://wamp.ws
//
//  A JavaScript library for WAMP ("The Web Application Messaging Protocol").
//
//  Copyright (c) Crossbar.io Technologies GmbH and contributors
//
//  Licensed under the MIT License.
//  http://www.opensource.org/licenses/mit-license.php
//
///////////////////////////////////////////////////////////////////////////////


function Transports() {
   this._repository = {};
}


Transports.prototype.register = function (name, factory) {
   this._repository[name] = factory;
};


Transports.prototype.isRegistered = function (name) {
   return this._repository[name] ? true : false;
};


Transports.prototype.get = function (name) {
   if (this._repository[name] !== undefined) {
      return this._repository[name];
   } else {
     throw "no such transport: " + name;
   }
}


Transports.prototype.list = function() {
   var items = [];
   for (var name in this._repository) {
      items.push(name);
   }
   return items;
};


var _transports = new Transports();


// register default transports
var websocket = require('./transport/websocket.js');
_transports.register("websocket", websocket.Factory);

var longpoll = require('./transport/longpoll.js');
_transports.register("longpoll", longpoll.Factory);

var rawsocket = require('./transport/rawsocket.js');
_transports.register("rawsocket", rawsocket.Factory);

exports.transports = _transports;
