// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface IDNSConfig {
    blocking_ipv4?: string;
    blocking_ipv6?: string;
    blocking_mode?: string;
    bootstrap_dns?: string[];
    cache_size?: number;
    cache_ttl_max?: number;
    cache_ttl_min?: number;
    dhcp_available?: boolean;
    dnssec_enabled?: boolean;
    edns_cs_enabled?: boolean;
    protection_enabled?: boolean;
    ratelimit?: number;
    upstream_dns?: string[];
    upstream_dns_file?: string;
    upstream_mode?: any;
}

export default class DNSConfig {
    readonly _blocking_ipv4: string | undefined;

    get blockingIpv4(): string | undefined {
        return this._blocking_ipv4;
    }

    readonly _blocking_ipv6: string | undefined;

    get blockingIpv6(): string | undefined {
        return this._blocking_ipv6;
    }

    readonly _blocking_mode: string | undefined;

    get blockingMode(): string | undefined {
        return this._blocking_mode;
    }

    readonly _bootstrap_dns: string[] | undefined;

    /**
     * Description: Bootstrap servers, port is optional after colon.  Empty value will reset it to default values.
     *
     * Example: 8.8.8.8:53,1.1.1.1:53
     */
    get bootstrapDns(): string[] | undefined {
        return this._bootstrap_dns;
    }

    readonly _cache_size: number | undefined;

    get cacheSize(): number | undefined {
        return this._cache_size;
    }

    readonly _cache_ttl_max: number | undefined;

    get cacheTtlMax(): number | undefined {
        return this._cache_ttl_max;
    }

    readonly _cache_ttl_min: number | undefined;

    get cacheTtlMin(): number | undefined {
        return this._cache_ttl_min;
    }

    readonly _dhcp_available: boolean | undefined;

    get dhcpAvailable(): boolean | undefined {
        return this._dhcp_available;
    }

    readonly _dnssec_enabled: boolean | undefined;

    get dnssecEnabled(): boolean | undefined {
        return this._dnssec_enabled;
    }

    readonly _edns_cs_enabled: boolean | undefined;

    get ednsCsEnabled(): boolean | undefined {
        return this._edns_cs_enabled;
    }

    readonly _protection_enabled: boolean | undefined;

    get protectionEnabled(): boolean | undefined {
        return this._protection_enabled;
    }

    readonly _ratelimit: number | undefined;

    get ratelimit(): number | undefined {
        return this._ratelimit;
    }

    readonly _upstream_dns: string[] | undefined;

    /**
     * Description: Upstream servers, port is optional after colon.  Empty value will reset it to default values.
     *
     * Example: tls://1.1.1.1,tls://1.0.0.1
     */
    get upstreamDns(): string[] | undefined {
        return this._upstream_dns;
    }

    readonly _upstream_dns_file: string | undefined;

    get upstreamDnsFile(): string | undefined {
        return this._upstream_dns_file;
    }

    readonly _upstream_mode: any | undefined;

    get upstreamMode(): any | undefined {
        return this._upstream_mode;
    }

    constructor(props: IDNSConfig) {
        if (typeof props.blocking_ipv4 === 'string') {
            this._blocking_ipv4 = props.blocking_ipv4.trim();
        }
        if (typeof props.blocking_ipv6 === 'string') {
            this._blocking_ipv6 = props.blocking_ipv6.trim();
        }
        if (typeof props.blocking_mode === 'string') {
            this._blocking_mode = props.blocking_mode.trim();
        }
        if (props.bootstrap_dns) {
            this._bootstrap_dns = props.bootstrap_dns;
        }
        if (typeof props.cache_size === 'number') {
            this._cache_size = props.cache_size;
        }
        if (typeof props.cache_ttl_max === 'number') {
            this._cache_ttl_max = props.cache_ttl_max;
        }
        if (typeof props.cache_ttl_min === 'number') {
            this._cache_ttl_min = props.cache_ttl_min;
        }
        if (typeof props.dhcp_available === 'boolean') {
            this._dhcp_available = props.dhcp_available;
        }
        if (typeof props.dnssec_enabled === 'boolean') {
            this._dnssec_enabled = props.dnssec_enabled;
        }
        if (typeof props.edns_cs_enabled === 'boolean') {
            this._edns_cs_enabled = props.edns_cs_enabled;
        }
        if (typeof props.protection_enabled === 'boolean') {
            this._protection_enabled = props.protection_enabled;
        }
        if (typeof props.ratelimit === 'number') {
            this._ratelimit = props.ratelimit;
        }
        if (props.upstream_dns) {
            this._upstream_dns = props.upstream_dns;
        }
        if (typeof props.upstream_dns_file === 'string') {
            this._upstream_dns_file = props.upstream_dns_file.trim();
        }
        if (props.upstream_mode) {
            this._upstream_mode = props.upstream_mode;
        }
    }

    serialize(): IDNSConfig {
        const data: IDNSConfig = {
        };
        if (typeof this._blocking_ipv4 !== 'undefined') {
            data.blocking_ipv4 = this._blocking_ipv4;
        }
        if (typeof this._blocking_ipv6 !== 'undefined') {
            data.blocking_ipv6 = this._blocking_ipv6;
        }
        if (typeof this._blocking_mode !== 'undefined') {
            data.blocking_mode = this._blocking_mode;
        }
        if (typeof this._bootstrap_dns !== 'undefined') {
            data.bootstrap_dns = this._bootstrap_dns;
        }
        if (typeof this._cache_size !== 'undefined') {
            data.cache_size = this._cache_size;
        }
        if (typeof this._cache_ttl_max !== 'undefined') {
            data.cache_ttl_max = this._cache_ttl_max;
        }
        if (typeof this._cache_ttl_min !== 'undefined') {
            data.cache_ttl_min = this._cache_ttl_min;
        }
        if (typeof this._dhcp_available !== 'undefined') {
            data.dhcp_available = this._dhcp_available;
        }
        if (typeof this._dnssec_enabled !== 'undefined') {
            data.dnssec_enabled = this._dnssec_enabled;
        }
        if (typeof this._edns_cs_enabled !== 'undefined') {
            data.edns_cs_enabled = this._edns_cs_enabled;
        }
        if (typeof this._protection_enabled !== 'undefined') {
            data.protection_enabled = this._protection_enabled;
        }
        if (typeof this._ratelimit !== 'undefined') {
            data.ratelimit = this._ratelimit;
        }
        if (typeof this._upstream_dns !== 'undefined') {
            data.upstream_dns = this._upstream_dns;
        }
        if (typeof this._upstream_dns_file !== 'undefined') {
            data.upstream_dns_file = this._upstream_dns_file;
        }
        if (typeof this._upstream_mode !== 'undefined') {
            data.upstream_mode = this._upstream_mode;
        }
        return data;
    }

    validate(): string[] {
        const validate = {
            bootstrap_dns: !this._bootstrap_dns ? true : this._bootstrap_dns.reduce((result, p) => result && typeof p === 'string', true),
            upstream_dns: !this._upstream_dns ? true : this._upstream_dns.reduce((result, p) => result && typeof p === 'string', true),
            upstream_dns_file: !this._upstream_dns_file ? true : typeof this._upstream_dns_file === 'string' && !this._upstream_dns_file ? true : this._upstream_dns_file,
            protection_enabled: !this._protection_enabled ? true : typeof this._protection_enabled === 'boolean',
            dhcp_available: !this._dhcp_available ? true : typeof this._dhcp_available === 'boolean',
            ratelimit: !this._ratelimit ? true : typeof this._ratelimit === 'number',
            blocking_mode: !this._blocking_mode ? true : typeof this._blocking_mode === 'string' && !this._blocking_mode ? true : this._blocking_mode,
            blocking_ipv4: !this._blocking_ipv4 ? true : typeof this._blocking_ipv4 === 'string' && !this._blocking_ipv4 ? true : this._blocking_ipv4,
            blocking_ipv6: !this._blocking_ipv6 ? true : typeof this._blocking_ipv6 === 'string' && !this._blocking_ipv6 ? true : this._blocking_ipv6,
            edns_cs_enabled: !this._edns_cs_enabled ? true : typeof this._edns_cs_enabled === 'boolean',
            dnssec_enabled: !this._dnssec_enabled ? true : typeof this._dnssec_enabled === 'boolean',
            cache_size: !this._cache_size ? true : typeof this._cache_size === 'number',
            cache_ttl_min: !this._cache_ttl_min ? true : typeof this._cache_ttl_min === 'number',
            cache_ttl_max: !this._cache_ttl_max ? true : typeof this._cache_ttl_max === 'number',
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<IDNSConfig>): DNSConfig {
        return new DNSConfig({ ...this.serialize(), ...props });
    }
}
