// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface INetInterface {
    flags: string;
    hardware_address: string;
    ip_addresses?: string[];
    mtu: number;
    name: string;
}

export default class NetInterface {
    readonly _flags: string;

    /**
     * Description: Flags could be any combination of the following values, divided by the "|" character: "up", "broadcast", "loopback", "pointtopoint" and "multicast".
     *
     * Example: up|broadcast|multicast
     */
    get flags(): string {
        return this._flags;
    }

    static flagsValidate(flags: string): boolean {
        return typeof flags === 'string' && !!flags.trim();
    }

    readonly _hardware_address: string;

    /**
     * Description: undefined
     * Example: 52:54:00:11:09:ba
     */
    get hardwareAddress(): string {
        return this._hardware_address;
    }

    static hardwareAddressValidate(hardwareAddress: string): boolean {
        return typeof hardwareAddress === 'string' && !!hardwareAddress.trim();
    }

    readonly _ip_addresses: string[] | undefined;

    get ipAddresses(): string[] | undefined {
        return this._ip_addresses;
    }

    readonly _mtu: number;

    get mtu(): number {
        return this._mtu;
    }

    static mtuValidate(mtu: number): boolean {
        return typeof mtu === 'number';
    }

    readonly _name: string;

    /**
     * Description: undefined
     * Example: eth0
     */
    get name(): string {
        return this._name;
    }

    static nameValidate(name: string): boolean {
        return typeof name === 'string' && !!name.trim();
    }

    constructor(props: INetInterface) {
        this._flags = props.flags.trim();
        this._hardware_address = props.hardware_address.trim();
        if (props.ip_addresses) {
            this._ip_addresses = props.ip_addresses;
        }
        this._mtu = props.mtu;
        this._name = props.name.trim();
    }

    serialize(): INetInterface {
        const data: INetInterface = {
            flags: this._flags,
            hardware_address: this._hardware_address,
            mtu: this._mtu,
            name: this._name,
        };
        if (typeof this._ip_addresses !== 'undefined') {
            data.ip_addresses = this._ip_addresses;
        }
        return data;
    }

    validate(): string[] {
        const validate = {
            flags: typeof this._flags === 'string' && !this._flags ? true : this._flags,
            hardware_address: typeof this._hardware_address === 'string' && !this._hardware_address ? true : this._hardware_address,
            name: typeof this._name === 'string' && !this._name ? true : this._name,
            ip_addresses: !this._ip_addresses ? true : this._ip_addresses.reduce((result, p) => result && typeof p === 'string', true),
            mtu: typeof this._mtu === 'number',
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<INetInterface>): NetInterface {
        return new NetInterface({ ...this.serialize(), ...props });
    }
}
