//--------------------------------------------------------------------------
// Copyright (C) 2019-2022 Cisco and/or its affiliates. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License Version 2 as published
// by the Free Software Foundation.  You may not use, modify or distribute
// this program under any other version of the GNU General Public License.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//--------------------------------------------------------------------------
// http2_huffman_state_machine.cc author Maya Dagon <mdagon@cisco.com>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "http2_huffman_state_machine.h"

const HuffmanEntry huffman_decode[HUFFMAN_LOOKUP_MAX+1] [UINT8_MAX+1] =
{
    { // HUFFMAN_LOOKUP_1
        {5, '0', HUFFMAN_MATCH}, {5, '0', HUFFMAN_MATCH}, {5, '0', HUFFMAN_MATCH}, {5, '0', HUFFMAN_MATCH},
        {5, '0', HUFFMAN_MATCH}, {5, '0', HUFFMAN_MATCH}, {5, '0', HUFFMAN_MATCH}, {5, '0', HUFFMAN_MATCH},
        {5, '1', HUFFMAN_MATCH}, {5, '1', HUFFMAN_MATCH}, {5, '1', HUFFMAN_MATCH}, {5, '1', HUFFMAN_MATCH},
        {5, '1', HUFFMAN_MATCH}, {5, '1', HUFFMAN_MATCH}, {5, '1', HUFFMAN_MATCH}, {5, '1', HUFFMAN_MATCH},
        {5, '2', HUFFMAN_MATCH}, {5, '2', HUFFMAN_MATCH}, {5, '2', HUFFMAN_MATCH}, {5, '2', HUFFMAN_MATCH},
        {5, '2', HUFFMAN_MATCH}, {5, '2', HUFFMAN_MATCH}, {5, '2', HUFFMAN_MATCH}, {5, '2', HUFFMAN_MATCH},
        {5, 'a', HUFFMAN_MATCH}, {5, 'a', HUFFMAN_MATCH}, {5, 'a', HUFFMAN_MATCH}, {5, 'a', HUFFMAN_MATCH},
        {5, 'a', HUFFMAN_MATCH}, {5, 'a', HUFFMAN_MATCH}, {5, 'a', HUFFMAN_MATCH}, {5, 'a', HUFFMAN_MATCH},
        {5, 'c', HUFFMAN_MATCH}, {5, 'c', HUFFMAN_MATCH}, {5, 'c', HUFFMAN_MATCH}, {5, 'c', HUFFMAN_MATCH},
        {5, 'c', HUFFMAN_MATCH}, {5, 'c', HUFFMAN_MATCH}, {5, 'c', HUFFMAN_MATCH}, {5, 'c', HUFFMAN_MATCH},
        {5, 'e', HUFFMAN_MATCH}, {5, 'e', HUFFMAN_MATCH}, {5, 'e', HUFFMAN_MATCH}, {5, 'e', HUFFMAN_MATCH},
        {5, 'e', HUFFMAN_MATCH}, {5, 'e', HUFFMAN_MATCH}, {5, 'e', HUFFMAN_MATCH}, {5, 'e', HUFFMAN_MATCH},
        {5, 'i', HUFFMAN_MATCH}, {5, 'i', HUFFMAN_MATCH}, {5, 'i', HUFFMAN_MATCH}, {5, 'i', HUFFMAN_MATCH},
        {5, 'i', HUFFMAN_MATCH}, {5, 'i', HUFFMAN_MATCH}, {5, 'i', HUFFMAN_MATCH}, {5, 'i', HUFFMAN_MATCH},
        {5, 'o', HUFFMAN_MATCH}, {5, 'o', HUFFMAN_MATCH}, {5, 'o', HUFFMAN_MATCH}, {5, 'o', HUFFMAN_MATCH},
        {5, 'o', HUFFMAN_MATCH}, {5, 'o', HUFFMAN_MATCH}, {5, 'o', HUFFMAN_MATCH}, {5, 'o', HUFFMAN_MATCH},
        {5, 's', HUFFMAN_MATCH}, {5, 's', HUFFMAN_MATCH}, {5, 's', HUFFMAN_MATCH}, {5, 's', HUFFMAN_MATCH},
        {5, 's', HUFFMAN_MATCH}, {5, 's', HUFFMAN_MATCH}, {5, 's', HUFFMAN_MATCH}, {5, 's', HUFFMAN_MATCH},
        {5, 't', HUFFMAN_MATCH}, {5, 't', HUFFMAN_MATCH}, {5, 't', HUFFMAN_MATCH}, {5, 't', HUFFMAN_MATCH},
        {5, 't', HUFFMAN_MATCH}, {5, 't', HUFFMAN_MATCH}, {5, 't', HUFFMAN_MATCH}, {5, 't', HUFFMAN_MATCH},
        {6, ' ', HUFFMAN_MATCH}, {6, ' ', HUFFMAN_MATCH}, {6, ' ', HUFFMAN_MATCH}, {6, ' ', HUFFMAN_MATCH},
        {6, '%', HUFFMAN_MATCH}, {6, '%', HUFFMAN_MATCH}, {6, '%', HUFFMAN_MATCH}, {6, '%', HUFFMAN_MATCH},
        {6, '-', HUFFMAN_MATCH}, {6, '-', HUFFMAN_MATCH}, {6, '-', HUFFMAN_MATCH}, {6, '-', HUFFMAN_MATCH},
        {6, '.', HUFFMAN_MATCH}, {6, '.', HUFFMAN_MATCH}, {6, '.', HUFFMAN_MATCH}, {6, '.', HUFFMAN_MATCH},
        {6, '/', HUFFMAN_MATCH}, {6, '/', HUFFMAN_MATCH}, {6, '/', HUFFMAN_MATCH}, {6, '/', HUFFMAN_MATCH},
        {6, '3', HUFFMAN_MATCH}, {6, '3', HUFFMAN_MATCH}, {6, '3', HUFFMAN_MATCH}, {6, '3', HUFFMAN_MATCH},
        {6, '4', HUFFMAN_MATCH}, {6, '4', HUFFMAN_MATCH}, {6, '4', HUFFMAN_MATCH}, {6, '4', HUFFMAN_MATCH},
        {6, '5', HUFFMAN_MATCH}, {6, '5', HUFFMAN_MATCH}, {6, '5', HUFFMAN_MATCH}, {6, '5', HUFFMAN_MATCH},
        {6, '6', HUFFMAN_MATCH}, {6, '6', HUFFMAN_MATCH}, {6, '6', HUFFMAN_MATCH}, {6, '6', HUFFMAN_MATCH},
        {6, '7', HUFFMAN_MATCH}, {6, '7', HUFFMAN_MATCH}, {6, '7', HUFFMAN_MATCH}, {6, '7', HUFFMAN_MATCH},
        {6, '8', HUFFMAN_MATCH}, {6, '8', HUFFMAN_MATCH}, {6, '8', HUFFMAN_MATCH}, {6, '8', HUFFMAN_MATCH},
        {6, '9', HUFFMAN_MATCH}, {6, '9', HUFFMAN_MATCH}, {6, '9', HUFFMAN_MATCH}, {6, '9', HUFFMAN_MATCH},
        {6, '=', HUFFMAN_MATCH}, {6, '=', HUFFMAN_MATCH}, {6, '=', HUFFMAN_MATCH}, {6, '=', HUFFMAN_MATCH},
        {6, 'A', HUFFMAN_MATCH}, {6, 'A', HUFFMAN_MATCH}, {6, 'A', HUFFMAN_MATCH}, {6, 'A', HUFFMAN_MATCH},
        {6, '_', HUFFMAN_MATCH}, {6, '_', HUFFMAN_MATCH}, {6, '_', HUFFMAN_MATCH}, {6, '_', HUFFMAN_MATCH},
        {6, 'b', HUFFMAN_MATCH}, {6, 'b', HUFFMAN_MATCH}, {6, 'b', HUFFMAN_MATCH}, {6, 'b', HUFFMAN_MATCH},
        {6, 'd', HUFFMAN_MATCH}, {6, 'd', HUFFMAN_MATCH}, {6, 'd', HUFFMAN_MATCH}, {6, 'd', HUFFMAN_MATCH},
        {6, 'f', HUFFMAN_MATCH}, {6, 'f', HUFFMAN_MATCH}, {6, 'f', HUFFMAN_MATCH}, {6, 'f', HUFFMAN_MATCH},
        {6, 'g', HUFFMAN_MATCH}, {6, 'g', HUFFMAN_MATCH}, {6, 'g', HUFFMAN_MATCH}, {6, 'g', HUFFMAN_MATCH},
        {6, 'h', HUFFMAN_MATCH}, {6, 'h', HUFFMAN_MATCH}, {6, 'h', HUFFMAN_MATCH}, {6, 'h', HUFFMAN_MATCH},
        {6, 'l', HUFFMAN_MATCH}, {6, 'l', HUFFMAN_MATCH}, {6, 'l', HUFFMAN_MATCH}, {6, 'l', HUFFMAN_MATCH},
        {6, 'm', HUFFMAN_MATCH}, {6, 'm', HUFFMAN_MATCH}, {6, 'm', HUFFMAN_MATCH}, {6, 'm', HUFFMAN_MATCH},
        {6, 'n', HUFFMAN_MATCH}, {6, 'n', HUFFMAN_MATCH}, {6, 'n', HUFFMAN_MATCH}, {6, 'n', HUFFMAN_MATCH},
        {6, 'p', HUFFMAN_MATCH}, {6, 'p', HUFFMAN_MATCH}, {6, 'p', HUFFMAN_MATCH}, {6, 'p', HUFFMAN_MATCH},
        {6, 'r', HUFFMAN_MATCH}, {6, 'r', HUFFMAN_MATCH}, {6, 'r', HUFFMAN_MATCH}, {6, 'r', HUFFMAN_MATCH},
        {6, 'u', HUFFMAN_MATCH}, {6, 'u', HUFFMAN_MATCH}, {6, 'u', HUFFMAN_MATCH}, {6, 'u', HUFFMAN_MATCH},
        {7, ':', HUFFMAN_MATCH}, {7, ':', HUFFMAN_MATCH}, {7, 'B', HUFFMAN_MATCH}, {7, 'B', HUFFMAN_MATCH},
        {7, 'C', HUFFMAN_MATCH}, {7, 'C', HUFFMAN_MATCH}, {7, 'D', HUFFMAN_MATCH}, {7, 'D', HUFFMAN_MATCH},
        {7, 'E', HUFFMAN_MATCH}, {7, 'E', HUFFMAN_MATCH}, {7, 'F', HUFFMAN_MATCH}, {7, 'F', HUFFMAN_MATCH},
        {7, 'G', HUFFMAN_MATCH}, {7, 'G', HUFFMAN_MATCH}, {7, 'H', HUFFMAN_MATCH}, {7, 'H', HUFFMAN_MATCH},
        {7, 'I', HUFFMAN_MATCH}, {7, 'I', HUFFMAN_MATCH}, {7, 'J', HUFFMAN_MATCH}, {7, 'J', HUFFMAN_MATCH},
        {7, 'K', HUFFMAN_MATCH}, {7, 'K', HUFFMAN_MATCH}, {7, 'L', HUFFMAN_MATCH}, {7, 'L', HUFFMAN_MATCH},
        {7, 'M', HUFFMAN_MATCH}, {7, 'M', HUFFMAN_MATCH}, {7, 'N', HUFFMAN_MATCH}, {7, 'N', HUFFMAN_MATCH},
        {7, 'O', HUFFMAN_MATCH}, {7, 'O', HUFFMAN_MATCH}, {7, 'P', HUFFMAN_MATCH}, {7, 'P', HUFFMAN_MATCH},
        {7, 'Q', HUFFMAN_MATCH}, {7, 'Q', HUFFMAN_MATCH}, {7, 'R', HUFFMAN_MATCH}, {7, 'R', HUFFMAN_MATCH},
        {7, 'S', HUFFMAN_MATCH}, {7, 'S', HUFFMAN_MATCH}, {7, 'T', HUFFMAN_MATCH}, {7, 'T', HUFFMAN_MATCH},
        {7, 'U', HUFFMAN_MATCH}, {7, 'U', HUFFMAN_MATCH}, {7, 'V', HUFFMAN_MATCH}, {7, 'V', HUFFMAN_MATCH},
        {7, 'W', HUFFMAN_MATCH}, {7, 'W', HUFFMAN_MATCH}, {7, 'Y', HUFFMAN_MATCH}, {7, 'Y', HUFFMAN_MATCH},
        {7, 'j', HUFFMAN_MATCH}, {7, 'j', HUFFMAN_MATCH}, {7, 'k', HUFFMAN_MATCH}, {7, 'k', HUFFMAN_MATCH},
        {7, 'q', HUFFMAN_MATCH}, {7, 'q', HUFFMAN_MATCH}, {7, 'v', HUFFMAN_MATCH}, {7, 'v', HUFFMAN_MATCH},
        {7, 'w', HUFFMAN_MATCH}, {7, 'w', HUFFMAN_MATCH}, {7, 'x', HUFFMAN_MATCH}, {7, 'x', HUFFMAN_MATCH},
        {7, 'y', HUFFMAN_MATCH}, {7, 'y', HUFFMAN_MATCH}, {7, 'z', HUFFMAN_MATCH}, {7, 'z', HUFFMAN_MATCH},
        {8, '&', HUFFMAN_MATCH}, {8, '*', HUFFMAN_MATCH}, {8, ',', HUFFMAN_MATCH}, {8, ';', HUFFMAN_MATCH},
        {8, 'X', HUFFMAN_MATCH}, {8, 'Z', HUFFMAN_MATCH}, {8, 0, HUFFMAN_LOOKUP_2}, {8, 0, HUFFMAN_LOOKUP_3}
    },
    { // HUFFMAN_LOOKUP_2
      // 00
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH}, {2, '!', HUFFMAN_MATCH},
        // 01
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH}, {2, '"', HUFFMAN_MATCH},
        // 10
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH}, {2, '(', HUFFMAN_MATCH},
        // 11
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH},
        {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}, {2, ')', HUFFMAN_MATCH}
    },
    { // HUFFMAN_LOOKUP_3
      // 00
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH}, {2, '?', HUFFMAN_MATCH},
        // 010
        {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH},
        {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH},
        {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH},
        {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH},
        {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH},
        {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH},
        {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH},
        {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH}, {3, '\'', HUFFMAN_MATCH},
        // 011
        {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH},
        {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH},
        {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH},
        {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH},
        {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH},
        {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH},
        {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH},
        {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH}, {3, '+', HUFFMAN_MATCH},
        // 100
        {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH},
        {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH},
        {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH},
        {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH},
        {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH},
        {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH},
        {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH},
        {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH}, {3, '|', HUFFMAN_MATCH},
        // 1010
        {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH},
        {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH},
        {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH},
        {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH}, {4, '#', HUFFMAN_MATCH},
        // 1011
        {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH},
        {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH},
        {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH},
        {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH}, {4, '>', HUFFMAN_MATCH},
        // 11000
        {5, 0, HUFFMAN_MATCH}, {5, 0, HUFFMAN_MATCH}, {5, 0, HUFFMAN_MATCH}, {5, 0, HUFFMAN_MATCH},
        {5, 0, HUFFMAN_MATCH}, {5, 0, HUFFMAN_MATCH}, {5, 0, HUFFMAN_MATCH}, {5, 0, HUFFMAN_MATCH},
        // 11001
        {5, '$', HUFFMAN_MATCH}, {5, '$', HUFFMAN_MATCH}, {5, '$', HUFFMAN_MATCH}, {5, '$', HUFFMAN_MATCH},
        {5, '$', HUFFMAN_MATCH}, {5, '$', HUFFMAN_MATCH}, {5, '$', HUFFMAN_MATCH}, {5, '$', HUFFMAN_MATCH},
        // 11010
        {5, '@', HUFFMAN_MATCH}, {5, '@', HUFFMAN_MATCH}, {5, '@', HUFFMAN_MATCH}, {5, '@', HUFFMAN_MATCH},
        {5, '@', HUFFMAN_MATCH}, {5, '@', HUFFMAN_MATCH}, {5, '@', HUFFMAN_MATCH}, {5, '@', HUFFMAN_MATCH},
        // 11011
        {5, '[', HUFFMAN_MATCH}, {5, '[', HUFFMAN_MATCH}, {5, '[', HUFFMAN_MATCH}, {5, '[', HUFFMAN_MATCH},
        {5, '[', HUFFMAN_MATCH}, {5, '[', HUFFMAN_MATCH}, {5, '[', HUFFMAN_MATCH}, {5, '[', HUFFMAN_MATCH},
        // 11100
        {5, ']', HUFFMAN_MATCH}, {5, ']', HUFFMAN_MATCH}, {5, ']', HUFFMAN_MATCH}, {5, ']', HUFFMAN_MATCH},
        {5, ']', HUFFMAN_MATCH}, {5, ']', HUFFMAN_MATCH}, {5, ']', HUFFMAN_MATCH}, {5, ']', HUFFMAN_MATCH},
        // 11101
        {5, '~', HUFFMAN_MATCH}, {5, '~', HUFFMAN_MATCH}, {5, '~', HUFFMAN_MATCH}, {5, '~', HUFFMAN_MATCH},
        {5, '~', HUFFMAN_MATCH}, {5, '~', HUFFMAN_MATCH}, {5, '~', HUFFMAN_MATCH}, {5, '~', HUFFMAN_MATCH},
        // 111100
        {6, '^', HUFFMAN_MATCH}, {6, '^', HUFFMAN_MATCH}, {6, '^', HUFFMAN_MATCH}, {6, '^', HUFFMAN_MATCH},
        // 111101
        {6, '}', HUFFMAN_MATCH}, {6, '}', HUFFMAN_MATCH}, {6, '}', HUFFMAN_MATCH}, {6, '}', HUFFMAN_MATCH},
        // 1111100
        {7, '<', HUFFMAN_MATCH}, {7, '<', HUFFMAN_MATCH},
        // 1111101
        {7, '`', HUFFMAN_MATCH}, {7, '`', HUFFMAN_MATCH},
        // 1111110
        {7, '{', HUFFMAN_MATCH}, {7, '{', HUFFMAN_MATCH},
        // 11111110
        {8, 0, HUFFMAN_LOOKUP_4},
        // 11111111
        {8, 0, HUFFMAN_LOOKUP_5}
    },
    { // HUFFMAN_LOOKUP_4
        // 000
        {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH},
        {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH},
        {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH},
        {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH},
        {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH},
        {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH},
        {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH},
        {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH}, {3, '\\', HUFFMAN_MATCH},
        // 001
        {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH},
        {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH},
        {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH},
        {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH},
        {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH},
        {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH},
        {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH},
        {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH}, {3, (char)195, HUFFMAN_MATCH},
        // 010
        {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH},
        {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH},
        {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH},
        {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH},
        {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH},
        {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH},
        {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH},
        {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH}, {3, (char)208, HUFFMAN_MATCH},
        // 0110
        {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH},
        {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH},
        {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH},
        {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH}, {4, (char)128, HUFFMAN_MATCH},
        // 0111
        {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH},
        {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH},
        {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH},
        {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH}, {4, (char)130, HUFFMAN_MATCH},
        // 1000
        {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH},
        {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH},
        {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH},
        {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH}, {4, (char)131, HUFFMAN_MATCH},
        // 1001
        {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH},
        {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH},
        {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH},
        {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH}, {4, (char)162, HUFFMAN_MATCH},
        // 1010
        {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH},
        {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH},
        {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH},
        {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH}, {4, (char)184, HUFFMAN_MATCH},
        // 1011
        {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH},
        {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH},
        {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH},
        {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH}, {4, (char)194, HUFFMAN_MATCH},
        // 1100
        {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH},
        {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH},
        {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH},
        {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH}, {4, (char)224, HUFFMAN_MATCH},
        // 1101
        {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH},
        {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH},
        {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH},
        {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH}, {4, (char)226, HUFFMAN_MATCH},
        // 11100
        {5, (char)153, HUFFMAN_MATCH}, {5, (char)153, HUFFMAN_MATCH}, {5, (char)153, HUFFMAN_MATCH}, {5, (char)153, HUFFMAN_MATCH},
        {5, (char)153, HUFFMAN_MATCH}, {5, (char)153, HUFFMAN_MATCH}, {5, (char)153, HUFFMAN_MATCH}, {5, (char)153, HUFFMAN_MATCH},
        // 11101
        {5, (char)161, HUFFMAN_MATCH}, {5, (char)161, HUFFMAN_MATCH}, {5, (char)161, HUFFMAN_MATCH}, {5, (char)161, HUFFMAN_MATCH},
        {5, (char)161, HUFFMAN_MATCH}, {5, (char)161, HUFFMAN_MATCH}, {5, (char)161, HUFFMAN_MATCH}, {5, (char)161, HUFFMAN_MATCH},
        // 11110
        {5, (char)167, HUFFMAN_MATCH}, {5, (char)167, HUFFMAN_MATCH}, {5, (char)167, HUFFMAN_MATCH}, {5, (char)167, HUFFMAN_MATCH},
        {5, (char)167, HUFFMAN_MATCH}, {5, (char)167, HUFFMAN_MATCH}, {5, (char)167, HUFFMAN_MATCH}, {5, (char)167, HUFFMAN_MATCH},
        // 11111
        {5, (char)172, HUFFMAN_MATCH}, {5, (char)172, HUFFMAN_MATCH}, {5, (char)172, HUFFMAN_MATCH}, {5, (char)172, HUFFMAN_MATCH},
        {5, (char)172, HUFFMAN_MATCH}, {5, (char)172, HUFFMAN_MATCH}, {5, (char)172, HUFFMAN_MATCH}, {5, (char)172, HUFFMAN_MATCH}
    },
    { // HUFFMAN_LOOKUP_5
        // 00000
        {5, (char)176, HUFFMAN_MATCH}, {5, (char)176, HUFFMAN_MATCH}, {5, (char)176, HUFFMAN_MATCH}, {5, (char)176, HUFFMAN_MATCH},
        {5, (char)176, HUFFMAN_MATCH}, {5, (char)176, HUFFMAN_MATCH}, {5, (char)176, HUFFMAN_MATCH}, {5, (char)176, HUFFMAN_MATCH},
        // 00001
        {5, (char)177, HUFFMAN_MATCH}, {5, (char)177, HUFFMAN_MATCH}, {5, (char)177, HUFFMAN_MATCH}, {5, (char)177, HUFFMAN_MATCH},
        {5, (char)177, HUFFMAN_MATCH}, {5, (char)177, HUFFMAN_MATCH}, {5, (char)177, HUFFMAN_MATCH}, {5, (char)177, HUFFMAN_MATCH},
        // 00010
        {5, (char)179, HUFFMAN_MATCH}, {5, (char)179, HUFFMAN_MATCH}, {5, (char)179, HUFFMAN_MATCH}, {5, (char)179, HUFFMAN_MATCH},
        {5, (char)179, HUFFMAN_MATCH}, {5, (char)179, HUFFMAN_MATCH}, {5, (char)179, HUFFMAN_MATCH}, {5, (char)179, HUFFMAN_MATCH},
        // 00011
        {5, (char)209, HUFFMAN_MATCH}, {5, (char)209, HUFFMAN_MATCH}, {5, (char)209, HUFFMAN_MATCH}, {5, (char)209, HUFFMAN_MATCH},
        {5, (char)209, HUFFMAN_MATCH}, {5, (char)209, HUFFMAN_MATCH}, {5, (char)209, HUFFMAN_MATCH}, {5, (char)209, HUFFMAN_MATCH},
        // 00100
        {5, (char)216, HUFFMAN_MATCH}, {5, (char)216, HUFFMAN_MATCH}, {5, (char)216, HUFFMAN_MATCH}, {5, (char)216, HUFFMAN_MATCH},
        {5, (char)216, HUFFMAN_MATCH}, {5, (char)216, HUFFMAN_MATCH}, {5, (char)216, HUFFMAN_MATCH}, {5, (char)216, HUFFMAN_MATCH},
        // 00101
        {5, (char)217, HUFFMAN_MATCH}, {5, (char)217, HUFFMAN_MATCH}, {5, (char)217, HUFFMAN_MATCH}, {5, (char)217, HUFFMAN_MATCH},
        {5, (char)217, HUFFMAN_MATCH}, {5, (char)217, HUFFMAN_MATCH}, {5, (char)217, HUFFMAN_MATCH}, {5, (char)217, HUFFMAN_MATCH},
        // 00110
        {5, (char)227, HUFFMAN_MATCH}, {5, (char)227, HUFFMAN_MATCH}, {5, (char)227, HUFFMAN_MATCH}, {5, (char)227, HUFFMAN_MATCH},
        {5, (char)227, HUFFMAN_MATCH}, {5, (char)227, HUFFMAN_MATCH}, {5, (char)227, HUFFMAN_MATCH}, {5, (char)227, HUFFMAN_MATCH},
        // 00111
        {5, (char)229, HUFFMAN_MATCH}, {5, (char)229, HUFFMAN_MATCH}, {5, (char)229, HUFFMAN_MATCH}, {5, (char)229, HUFFMAN_MATCH},
        {5, (char)229, HUFFMAN_MATCH}, {5, (char)229, HUFFMAN_MATCH}, {5, (char)229, HUFFMAN_MATCH}, {5, (char)229, HUFFMAN_MATCH},
        // 01000
        {5, (char)230, HUFFMAN_MATCH}, {5, (char)230, HUFFMAN_MATCH}, {5, (char)230, HUFFMAN_MATCH}, {5, (char)230, HUFFMAN_MATCH},
        {5, (char)230, HUFFMAN_MATCH}, {5, (char)230, HUFFMAN_MATCH}, {5, (char)230, HUFFMAN_MATCH}, {5, (char)230, HUFFMAN_MATCH},
        // 010010
        {6, (char)129, HUFFMAN_MATCH}, {6, (char)129, HUFFMAN_MATCH}, {6, (char)129, HUFFMAN_MATCH}, {6, (char)129, HUFFMAN_MATCH},
        // 010011
        {6, (char)132, HUFFMAN_MATCH}, {6, (char)132, HUFFMAN_MATCH}, {6, (char)132, HUFFMAN_MATCH}, {6, (char)132, HUFFMAN_MATCH},
        // 010100
        {6, (char)133, HUFFMAN_MATCH}, {6, (char)133, HUFFMAN_MATCH}, {6, (char)133, HUFFMAN_MATCH}, {6, (char)133, HUFFMAN_MATCH},
        // 010101
        {6, (char)134, HUFFMAN_MATCH}, {6, (char)134, HUFFMAN_MATCH}, {6, (char)134, HUFFMAN_MATCH}, {6, (char)134, HUFFMAN_MATCH},
        // 010110
        {6, (char)136, HUFFMAN_MATCH}, {6, (char)136, HUFFMAN_MATCH}, {6, (char)136, HUFFMAN_MATCH}, {6, (char)136, HUFFMAN_MATCH},
        // 010111
        {6, (char)146, HUFFMAN_MATCH}, {6, (char)146, HUFFMAN_MATCH}, {6, (char)146, HUFFMAN_MATCH}, {6, (char)146, HUFFMAN_MATCH},
        // 011000
        {6, (char)154, HUFFMAN_MATCH}, {6, (char)154, HUFFMAN_MATCH}, {6, (char)154, HUFFMAN_MATCH}, {6, (char)154, HUFFMAN_MATCH},
        // 011001
        {6, (char)156, HUFFMAN_MATCH}, {6, (char)156, HUFFMAN_MATCH}, {6, (char)156, HUFFMAN_MATCH}, {6, (char)156, HUFFMAN_MATCH},
        // 011010
        {6, (char)160, HUFFMAN_MATCH}, {6, (char)160, HUFFMAN_MATCH}, {6, (char)160, HUFFMAN_MATCH}, {6, (char)160, HUFFMAN_MATCH},
        // 011011
        {6, (char)163, HUFFMAN_MATCH}, {6, (char)163, HUFFMAN_MATCH}, {6, (char)163, HUFFMAN_MATCH}, {6, (char)163, HUFFMAN_MATCH},
        // 011100
        {6, (char)164, HUFFMAN_MATCH}, {6, (char)164, HUFFMAN_MATCH}, {6, (char)164, HUFFMAN_MATCH}, {6, (char)164, HUFFMAN_MATCH},
        // 011101
        {6, (char)169, HUFFMAN_MATCH}, {6, (char)169, HUFFMAN_MATCH}, {6, (char)169, HUFFMAN_MATCH}, {6, (char)169, HUFFMAN_MATCH},
        // 011110
        {6, (char)170, HUFFMAN_MATCH}, {6, (char)170, HUFFMAN_MATCH}, {6, (char)170, HUFFMAN_MATCH}, {6, (char)170, HUFFMAN_MATCH},
        // 011111
        {6, (char)173, HUFFMAN_MATCH}, {6, (char)173, HUFFMAN_MATCH}, {6, (char)173, HUFFMAN_MATCH}, {6, (char)173, HUFFMAN_MATCH},
        // 100000
        {6, (char)178, HUFFMAN_MATCH}, {6, (char)178, HUFFMAN_MATCH}, {6, (char)178, HUFFMAN_MATCH}, {6, (char)178, HUFFMAN_MATCH},
        // 100001
        {6, (char)181, HUFFMAN_MATCH}, {6, (char)181, HUFFMAN_MATCH}, {6, (char)181, HUFFMAN_MATCH}, {6, (char)181, HUFFMAN_MATCH},
        // 100010
        {6, (char)185, HUFFMAN_MATCH}, {6, (char)185, HUFFMAN_MATCH}, {6, (char)185, HUFFMAN_MATCH}, {6, (char)185, HUFFMAN_MATCH},
        // 100011
        {6, (char)186, HUFFMAN_MATCH}, {6, (char)186, HUFFMAN_MATCH}, {6, (char)186, HUFFMAN_MATCH}, {6, (char)186, HUFFMAN_MATCH},
        // 100100
        {6, (char)187, HUFFMAN_MATCH}, {6, (char)187, HUFFMAN_MATCH}, {6, (char)187, HUFFMAN_MATCH}, {6, (char)187, HUFFMAN_MATCH},
        // 100101
        {6, (char)189, HUFFMAN_MATCH}, {6, (char)189, HUFFMAN_MATCH}, {6, (char)189, HUFFMAN_MATCH}, {6, (char)189, HUFFMAN_MATCH},
        // 100110
        {6, (char)190, HUFFMAN_MATCH}, {6, (char)190, HUFFMAN_MATCH}, {6, (char)190, HUFFMAN_MATCH}, {6, (char)190, HUFFMAN_MATCH},
        // 100111
        {6, (char)196, HUFFMAN_MATCH}, {6, (char)196, HUFFMAN_MATCH}, {6, (char)196, HUFFMAN_MATCH}, {6, (char)196, HUFFMAN_MATCH},
        // 101000
        {6, (char)198, HUFFMAN_MATCH}, {6, (char)198, HUFFMAN_MATCH}, {6, (char)198, HUFFMAN_MATCH}, {6, (char)198, HUFFMAN_MATCH},
        // 101001
        {6, (char)228, HUFFMAN_MATCH}, {6, (char)228, HUFFMAN_MATCH}, {6, (char)228, HUFFMAN_MATCH}, {6, (char)228, HUFFMAN_MATCH},
        // 101010
        {6, (char)232, HUFFMAN_MATCH}, {6, (char)232, HUFFMAN_MATCH}, {6, (char)232, HUFFMAN_MATCH}, {6, (char)232, HUFFMAN_MATCH},
        // 101011
        {6, (char)233, HUFFMAN_MATCH}, {6, (char)233, HUFFMAN_MATCH}, {6, (char)233, HUFFMAN_MATCH}, {6, (char)233, HUFFMAN_MATCH},
        // 1011000
        {7, (char)1, HUFFMAN_MATCH}, {7, (char)1, HUFFMAN_MATCH},
        // 1011001
        {7, (char)135, HUFFMAN_MATCH}, {7, (char)135, HUFFMAN_MATCH},
        // 1011010
        {7, (char)137, HUFFMAN_MATCH}, {7, (char)137, HUFFMAN_MATCH},
        // 1011011
        {7, (char)138, HUFFMAN_MATCH}, {7, (char)138, HUFFMAN_MATCH},
        // 1011100
        {7, (char)139, HUFFMAN_MATCH}, {7, (char)139, HUFFMAN_MATCH},
        // 1011101
        {7, (char)140, HUFFMAN_MATCH}, {7, (char)140, HUFFMAN_MATCH},
        // 1011110
        {7, (char)141, HUFFMAN_MATCH}, {7, (char)141, HUFFMAN_MATCH},
        // 1011111
        {7, (char)143, HUFFMAN_MATCH}, {7, (char)143, HUFFMAN_MATCH},
        // 1100000
        {7, (char)147, HUFFMAN_MATCH}, {7, (char)147, HUFFMAN_MATCH},
        // 1100001
        {7, (char)149, HUFFMAN_MATCH}, {7, (char)149, HUFFMAN_MATCH},
        // 1100010
        {7, (char)150, HUFFMAN_MATCH}, {7, (char)150, HUFFMAN_MATCH},
        // 1100011
        {7, (char)151, HUFFMAN_MATCH}, {7, (char)151, HUFFMAN_MATCH},
        // 1100100
        {7, (char)152, HUFFMAN_MATCH}, {7, (char)152, HUFFMAN_MATCH},
        // 1100101
        {7, (char)155, HUFFMAN_MATCH}, {7, (char)155, HUFFMAN_MATCH},
        // 1100110
        {7, (char)157, HUFFMAN_MATCH}, {7, (char)157, HUFFMAN_MATCH},
        // 1100111
        {7, (char)158, HUFFMAN_MATCH}, {7, (char)158, HUFFMAN_MATCH},
        // 1101000
        {7, (char)165, HUFFMAN_MATCH}, {7, (char)165, HUFFMAN_MATCH},
        // 1101001
        {7, (char)166, HUFFMAN_MATCH}, {7, (char)166, HUFFMAN_MATCH},
        // 1101010
        {7, (char)168, HUFFMAN_MATCH}, {7, (char)168, HUFFMAN_MATCH},
        // 1101011
        {7, (char)174, HUFFMAN_MATCH}, {7, (char)174, HUFFMAN_MATCH},
        // 1101100
        {7, (char)175, HUFFMAN_MATCH}, {7, (char)175, HUFFMAN_MATCH},
        // 1101101
        {7, (char)180, HUFFMAN_MATCH}, {7, (char)180, HUFFMAN_MATCH},
        // 1101110
        {7, (char)182, HUFFMAN_MATCH}, {7, (char)182, HUFFMAN_MATCH},
        // 1101111
        {7, (char)183, HUFFMAN_MATCH}, {7, (char)183, HUFFMAN_MATCH},
        // 1110000
        {7, (char)188, HUFFMAN_MATCH}, {7, (char)188, HUFFMAN_MATCH},
        // 1110001
        {7, (char)191, HUFFMAN_MATCH}, {7, (char)191, HUFFMAN_MATCH},
        // 1110010
        {7, (char)197, HUFFMAN_MATCH}, {7, (char)197, HUFFMAN_MATCH},
        // 1100111
        {7, (char)231, HUFFMAN_MATCH}, {7, (char)231, HUFFMAN_MATCH},
        // 1110100
        {7, (char)239, HUFFMAN_MATCH}, {7, (char)239, HUFFMAN_MATCH},
        // 11101010
        {8, (char)9, HUFFMAN_MATCH}, {8, (char)142, HUFFMAN_MATCH},
        {8, (char)144, HUFFMAN_MATCH}, {8, (char)145, HUFFMAN_MATCH},
        {8, (char)148, HUFFMAN_MATCH}, {8, (char)159, HUFFMAN_MATCH},
        {8, (char)171, HUFFMAN_MATCH}, {8, (char)206, HUFFMAN_MATCH},
        {8, (char)215, HUFFMAN_MATCH}, {8, (char)225, HUFFMAN_MATCH},
        {8, (char)236, HUFFMAN_MATCH}, {8, (char)237, HUFFMAN_MATCH},
        {8, 0, HUFFMAN_LOOKUP_6}, {8, 0, HUFFMAN_LOOKUP_7},
        {8, 0, HUFFMAN_LOOKUP_8}, {8, 0, HUFFMAN_LOOKUP_9},
        {8, 0, HUFFMAN_LOOKUP_10}, {8, 0, HUFFMAN_LOOKUP_11},
        {8, 0, HUFFMAN_LOOKUP_12}, {8, 0, HUFFMAN_LOOKUP_13},
        {8, 0, HUFFMAN_LOOKUP_14}, {8, 0, HUFFMAN_LOOKUP_15}
    },
    { // HUFFMAN_LOOKUP_6
        // 0
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        {1, (char)199, HUFFMAN_MATCH}, {1, (char)199, HUFFMAN_MATCH},
        // 1
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
        {1, (char)207, HUFFMAN_MATCH}, {1, (char)207, HUFFMAN_MATCH},
    },
    { // HUFFMAN_LOOKUP_7
        // 0
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        {1, (char)234, HUFFMAN_MATCH}, {1, (char)234, HUFFMAN_MATCH},
        // 1
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
        {1, (char)235, HUFFMAN_MATCH}, {1, (char)235, HUFFMAN_MATCH},
    },
    { // HUFFMAN_LOOKUP_8
        // 00
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        {2, (char)192, HUFFMAN_MATCH}, {2, (char)192, HUFFMAN_MATCH},
        // 01
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        {2, (char)193, HUFFMAN_MATCH}, {2, (char)193, HUFFMAN_MATCH},
        // 10
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        {2, (char)200, HUFFMAN_MATCH}, {2, (char)200, HUFFMAN_MATCH},
        // 11
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
        {2, (char)201, HUFFMAN_MATCH}, {2, (char)201, HUFFMAN_MATCH},
    },
    { // HUFFMAN_LOOKUP_9
        // 00
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        {2, (char)202, HUFFMAN_MATCH}, {2, (char)202, HUFFMAN_MATCH},
        // 01
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        {2, (char)205, HUFFMAN_MATCH}, {2, (char)205, HUFFMAN_MATCH},
        // 10
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        {2, (char)210, HUFFMAN_MATCH}, {2, (char)210, HUFFMAN_MATCH},
        // 11
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
        {2, (char)213, HUFFMAN_MATCH}, {2, (char)213, HUFFMAN_MATCH},
    },
    { // HUFFMAN_LOOKUP_10
        // 00
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        {2, (char)218, HUFFMAN_MATCH}, {2, (char)218, HUFFMAN_MATCH},
        // 01
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        {2, (char)219, HUFFMAN_MATCH}, {2, (char)219, HUFFMAN_MATCH},
        // 10
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        {2, (char)238, HUFFMAN_MATCH}, {2, (char)238, HUFFMAN_MATCH},
        // 11
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
        {2, (char)240, HUFFMAN_MATCH}, {2, (char)240, HUFFMAN_MATCH},
    },
    { // HUFFMAN_LOOKUP_11
        // 00
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        {2, (char)242, HUFFMAN_MATCH}, {2, (char)242, HUFFMAN_MATCH},
        // 01
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        {2, (char)243, HUFFMAN_MATCH}, {2, (char)243, HUFFMAN_MATCH},
        // 10
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        {2, (char)255, HUFFMAN_MATCH}, {2, (char)255, HUFFMAN_MATCH},
        // 110
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        {3, (char)203, HUFFMAN_MATCH}, {3, (char)203, HUFFMAN_MATCH},
        //111
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
        {3, (char)204, HUFFMAN_MATCH}, {3, (char)204, HUFFMAN_MATCH},
    },
    { // HUFFMAN_LOOKUP_12
        // 000
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        {3, (char)211, HUFFMAN_MATCH}, {3, (char)211, HUFFMAN_MATCH},
        // 001
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        {3, (char)212, HUFFMAN_MATCH}, {3, (char)212, HUFFMAN_MATCH},
        // 010
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        {3, (char)214, HUFFMAN_MATCH}, {3, (char)214, HUFFMAN_MATCH},
        // 011
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        {3, (char)221, HUFFMAN_MATCH}, {3, (char)221, HUFFMAN_MATCH},
        // 100
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        {3, (char)222, HUFFMAN_MATCH}, {3, (char)222, HUFFMAN_MATCH},
        // 101
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        {3, (char)223, HUFFMAN_MATCH}, {3, (char)223, HUFFMAN_MATCH},
        // 110
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        {3, (char)241, HUFFMAN_MATCH}, {3, (char)241, HUFFMAN_MATCH},
        // 111
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
        {3, (char)244, HUFFMAN_MATCH}, {3, (char)244, HUFFMAN_MATCH},
    },
    { // HUFFMAN_LOOKUP_13
        // 000
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        {3, (char)245, HUFFMAN_MATCH}, {3, (char)245, HUFFMAN_MATCH},
        // 001
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        {3, (char)246, HUFFMAN_MATCH}, {3, (char)246, HUFFMAN_MATCH},
        // 010
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        {3, (char)247, HUFFMAN_MATCH}, {3, (char)247, HUFFMAN_MATCH},
        // 011
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        {3, (char)248, HUFFMAN_MATCH}, {3, (char)248, HUFFMAN_MATCH},
        // 100
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        {3, (char)250, HUFFMAN_MATCH}, {3, (char)250, HUFFMAN_MATCH},
        // 101
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        {3, (char)251, HUFFMAN_MATCH}, {3, (char)251, HUFFMAN_MATCH},
        // 110
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        {3, (char)252, HUFFMAN_MATCH}, {3, (char)252, HUFFMAN_MATCH},
        // 111
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
        {3, (char)253, HUFFMAN_MATCH}, {3, (char)253, HUFFMAN_MATCH},
    },
    { // HUFFMAN_LOOKUP_14
        // 000
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        {3, (char)254, HUFFMAN_MATCH}, {3, (char)254, HUFFMAN_MATCH},
        // 0010
        {4, (char)2, HUFFMAN_MATCH}, {4, (char)2, HUFFMAN_MATCH},
        {4, (char)2, HUFFMAN_MATCH}, {4, (char)2, HUFFMAN_MATCH},
        {4, (char)2, HUFFMAN_MATCH}, {4, (char)2, HUFFMAN_MATCH},
        {4, (char)2, HUFFMAN_MATCH}, {4, (char)2, HUFFMAN_MATCH},
        {4, (char)2, HUFFMAN_MATCH}, {4, (char)2, HUFFMAN_MATCH},
        {4, (char)2, HUFFMAN_MATCH}, {4, (char)2, HUFFMAN_MATCH},
        {4, (char)2, HUFFMAN_MATCH}, {4, (char)2, HUFFMAN_MATCH},
        {4, (char)2, HUFFMAN_MATCH}, {4, (char)2, HUFFMAN_MATCH},
        // 0011
        {4, (char)3, HUFFMAN_MATCH}, {4, (char)3, HUFFMAN_MATCH},
        {4, (char)3, HUFFMAN_MATCH}, {4, (char)3, HUFFMAN_MATCH},
        {4, (char)3, HUFFMAN_MATCH}, {4, (char)3, HUFFMAN_MATCH},
        {4, (char)3, HUFFMAN_MATCH}, {4, (char)3, HUFFMAN_MATCH},
        {4, (char)3, HUFFMAN_MATCH}, {4, (char)3, HUFFMAN_MATCH},
        {4, (char)3, HUFFMAN_MATCH}, {4, (char)3, HUFFMAN_MATCH},
        {4, (char)3, HUFFMAN_MATCH}, {4, (char)3, HUFFMAN_MATCH},
        {4, (char)3, HUFFMAN_MATCH}, {4, (char)3, HUFFMAN_MATCH},
        // 0100
        {4, (char)4, HUFFMAN_MATCH}, {4, (char)4, HUFFMAN_MATCH},
        {4, (char)4, HUFFMAN_MATCH}, {4, (char)4, HUFFMAN_MATCH},
        {4, (char)4, HUFFMAN_MATCH}, {4, (char)4, HUFFMAN_MATCH},
        {4, (char)4, HUFFMAN_MATCH}, {4, (char)4, HUFFMAN_MATCH},
        {4, (char)4, HUFFMAN_MATCH}, {4, (char)4, HUFFMAN_MATCH},
        {4, (char)4, HUFFMAN_MATCH}, {4, (char)4, HUFFMAN_MATCH},
        {4, (char)4, HUFFMAN_MATCH}, {4, (char)4, HUFFMAN_MATCH},
        {4, (char)4, HUFFMAN_MATCH}, {4, (char)4, HUFFMAN_MATCH},
        // 0101
        {4, (char)5, HUFFMAN_MATCH}, {4, (char)5, HUFFMAN_MATCH},
        {4, (char)5, HUFFMAN_MATCH}, {4, (char)5, HUFFMAN_MATCH},
        {4, (char)5, HUFFMAN_MATCH}, {4, (char)5, HUFFMAN_MATCH},
        {4, (char)5, HUFFMAN_MATCH}, {4, (char)5, HUFFMAN_MATCH},
        {4, (char)5, HUFFMAN_MATCH}, {4, (char)5, HUFFMAN_MATCH},
        {4, (char)5, HUFFMAN_MATCH}, {4, (char)5, HUFFMAN_MATCH},
        {4, (char)5, HUFFMAN_MATCH}, {4, (char)5, HUFFMAN_MATCH},
        {4, (char)5, HUFFMAN_MATCH}, {4, (char)5, HUFFMAN_MATCH},
        // 0110
        {4, (char)6, HUFFMAN_MATCH}, {4, (char)6, HUFFMAN_MATCH},
        {4, (char)6, HUFFMAN_MATCH}, {4, (char)6, HUFFMAN_MATCH},
        {4, (char)6, HUFFMAN_MATCH}, {4, (char)6, HUFFMAN_MATCH},
        {4, (char)6, HUFFMAN_MATCH}, {4, (char)6, HUFFMAN_MATCH},
        {4, (char)6, HUFFMAN_MATCH}, {4, (char)6, HUFFMAN_MATCH},
        {4, (char)6, HUFFMAN_MATCH}, {4, (char)6, HUFFMAN_MATCH},
        {4, (char)6, HUFFMAN_MATCH}, {4, (char)6, HUFFMAN_MATCH},
        {4, (char)6, HUFFMAN_MATCH}, {4, (char)6, HUFFMAN_MATCH},
        // 0111
        {4, (char)7, HUFFMAN_MATCH}, {4, (char)7, HUFFMAN_MATCH},
        {4, (char)7, HUFFMAN_MATCH}, {4, (char)7, HUFFMAN_MATCH},
        {4, (char)7, HUFFMAN_MATCH}, {4, (char)7, HUFFMAN_MATCH},
        {4, (char)7, HUFFMAN_MATCH}, {4, (char)7, HUFFMAN_MATCH},
        {4, (char)7, HUFFMAN_MATCH}, {4, (char)7, HUFFMAN_MATCH},
        {4, (char)7, HUFFMAN_MATCH}, {4, (char)7, HUFFMAN_MATCH},
        {4, (char)7, HUFFMAN_MATCH}, {4, (char)7, HUFFMAN_MATCH},
        {4, (char)7, HUFFMAN_MATCH}, {4, (char)7, HUFFMAN_MATCH},
        // 1000
        {4, (char)8, HUFFMAN_MATCH}, {4, (char)8, HUFFMAN_MATCH},
        {4, (char)8, HUFFMAN_MATCH}, {4, (char)8, HUFFMAN_MATCH},
        {4, (char)8, HUFFMAN_MATCH}, {4, (char)8, HUFFMAN_MATCH},
        {4, (char)8, HUFFMAN_MATCH}, {4, (char)8, HUFFMAN_MATCH},
        {4, (char)8, HUFFMAN_MATCH}, {4, (char)8, HUFFMAN_MATCH},
        {4, (char)8, HUFFMAN_MATCH}, {4, (char)8, HUFFMAN_MATCH},
        {4, (char)8, HUFFMAN_MATCH}, {4, (char)8, HUFFMAN_MATCH},
        {4, (char)8, HUFFMAN_MATCH}, {4, (char)8, HUFFMAN_MATCH},
        // 1001
        {4, (char)11, HUFFMAN_MATCH}, {4, (char)11, HUFFMAN_MATCH},
        {4, (char)11, HUFFMAN_MATCH}, {4, (char)11, HUFFMAN_MATCH},
        {4, (char)11, HUFFMAN_MATCH}, {4, (char)11, HUFFMAN_MATCH},
        {4, (char)11, HUFFMAN_MATCH}, {4, (char)11, HUFFMAN_MATCH},
        {4, (char)11, HUFFMAN_MATCH}, {4, (char)11, HUFFMAN_MATCH},
        {4, (char)11, HUFFMAN_MATCH}, {4, (char)11, HUFFMAN_MATCH},
        {4, (char)11, HUFFMAN_MATCH}, {4, (char)11, HUFFMAN_MATCH},
        {4, (char)11, HUFFMAN_MATCH}, {4, (char)11, HUFFMAN_MATCH},
        // 1010
        {4, (char)12, HUFFMAN_MATCH}, {4, (char)12, HUFFMAN_MATCH},
        {4, (char)12, HUFFMAN_MATCH}, {4, (char)12, HUFFMAN_MATCH},
        {4, (char)12, HUFFMAN_MATCH}, {4, (char)12, HUFFMAN_MATCH},
        {4, (char)12, HUFFMAN_MATCH}, {4, (char)12, HUFFMAN_MATCH},
        {4, (char)12, HUFFMAN_MATCH}, {4, (char)12, HUFFMAN_MATCH},
        {4, (char)12, HUFFMAN_MATCH}, {4, (char)12, HUFFMAN_MATCH},
        {4, (char)12, HUFFMAN_MATCH}, {4, (char)12, HUFFMAN_MATCH},
        {4, (char)12, HUFFMAN_MATCH}, {4, (char)12, HUFFMAN_MATCH},
        // 1011
        {4, (char)14, HUFFMAN_MATCH}, {4, (char)14, HUFFMAN_MATCH},
        {4, (char)14, HUFFMAN_MATCH}, {4, (char)14, HUFFMAN_MATCH},
        {4, (char)14, HUFFMAN_MATCH}, {4, (char)14, HUFFMAN_MATCH},
        {4, (char)14, HUFFMAN_MATCH}, {4, (char)14, HUFFMAN_MATCH},
        {4, (char)14, HUFFMAN_MATCH}, {4, (char)14, HUFFMAN_MATCH},
        {4, (char)14, HUFFMAN_MATCH}, {4, (char)14, HUFFMAN_MATCH},
        {4, (char)14, HUFFMAN_MATCH}, {4, (char)14, HUFFMAN_MATCH},
        {4, (char)14, HUFFMAN_MATCH}, {4, (char)14, HUFFMAN_MATCH},
        // 1100
        {4, (char)15, HUFFMAN_MATCH}, {4, (char)15, HUFFMAN_MATCH},
        {4, (char)15, HUFFMAN_MATCH}, {4, (char)15, HUFFMAN_MATCH},
        {4, (char)15, HUFFMAN_MATCH}, {4, (char)15, HUFFMAN_MATCH},
        {4, (char)15, HUFFMAN_MATCH}, {4, (char)15, HUFFMAN_MATCH},
        {4, (char)15, HUFFMAN_MATCH}, {4, (char)15, HUFFMAN_MATCH},
        {4, (char)15, HUFFMAN_MATCH}, {4, (char)15, HUFFMAN_MATCH},
        {4, (char)15, HUFFMAN_MATCH}, {4, (char)15, HUFFMAN_MATCH},
        {4, (char)15, HUFFMAN_MATCH}, {4, (char)15, HUFFMAN_MATCH},
        // 1101
        {4, (char)16, HUFFMAN_MATCH}, {4, (char)16, HUFFMAN_MATCH},
        {4, (char)16, HUFFMAN_MATCH}, {4, (char)16, HUFFMAN_MATCH},
        {4, (char)16, HUFFMAN_MATCH}, {4, (char)16, HUFFMAN_MATCH},
        {4, (char)16, HUFFMAN_MATCH}, {4, (char)16, HUFFMAN_MATCH},
        {4, (char)16, HUFFMAN_MATCH}, {4, (char)16, HUFFMAN_MATCH},
        {4, (char)16, HUFFMAN_MATCH}, {4, (char)16, HUFFMAN_MATCH},
        {4, (char)16, HUFFMAN_MATCH}, {4, (char)16, HUFFMAN_MATCH},
        {4, (char)16, HUFFMAN_MATCH}, {4, (char)16, HUFFMAN_MATCH},
        // 1110
        {4, (char)17, HUFFMAN_MATCH}, {4, (char)17, HUFFMAN_MATCH},
        {4, (char)17, HUFFMAN_MATCH}, {4, (char)17, HUFFMAN_MATCH},
        {4, (char)17, HUFFMAN_MATCH}, {4, (char)17, HUFFMAN_MATCH},
        {4, (char)17, HUFFMAN_MATCH}, {4, (char)17, HUFFMAN_MATCH},
        {4, (char)17, HUFFMAN_MATCH}, {4, (char)17, HUFFMAN_MATCH},
        {4, (char)17, HUFFMAN_MATCH}, {4, (char)17, HUFFMAN_MATCH},
        {4, (char)17, HUFFMAN_MATCH}, {4, (char)17, HUFFMAN_MATCH},
        {4, (char)17, HUFFMAN_MATCH}, {4, (char)17, HUFFMAN_MATCH},
        // 1111
        {4, (char)18, HUFFMAN_MATCH}, {4, (char)18, HUFFMAN_MATCH},
        {4, (char)18, HUFFMAN_MATCH}, {4, (char)18, HUFFMAN_MATCH},
        {4, (char)18, HUFFMAN_MATCH}, {4, (char)18, HUFFMAN_MATCH},
        {4, (char)18, HUFFMAN_MATCH}, {4, (char)18, HUFFMAN_MATCH},
        {4, (char)18, HUFFMAN_MATCH}, {4, (char)18, HUFFMAN_MATCH},
        {4, (char)18, HUFFMAN_MATCH}, {4, (char)18, HUFFMAN_MATCH},
        {4, (char)18, HUFFMAN_MATCH}, {4, (char)18, HUFFMAN_MATCH},
        {4, (char)18, HUFFMAN_MATCH}, {4, (char)18, HUFFMAN_MATCH},
    },
    { // HUFFMAN_LOOKUP_15
        // 0000
        {4, (char)19, HUFFMAN_MATCH}, {4, (char)19, HUFFMAN_MATCH},
        {4, (char)19, HUFFMAN_MATCH}, {4, (char)19, HUFFMAN_MATCH},
        {4, (char)19, HUFFMAN_MATCH}, {4, (char)19, HUFFMAN_MATCH},
        {4, (char)19, HUFFMAN_MATCH}, {4, (char)19, HUFFMAN_MATCH},
        {4, (char)19, HUFFMAN_MATCH}, {4, (char)19, HUFFMAN_MATCH},
        {4, (char)19, HUFFMAN_MATCH}, {4, (char)19, HUFFMAN_MATCH},
        {4, (char)19, HUFFMAN_MATCH}, {4, (char)19, HUFFMAN_MATCH},
        {4, (char)19, HUFFMAN_MATCH}, {4, (char)19, HUFFMAN_MATCH},
        // 0001
        {4, (char)20, HUFFMAN_MATCH}, {4, (char)20, HUFFMAN_MATCH},
        {4, (char)20, HUFFMAN_MATCH}, {4, (char)20, HUFFMAN_MATCH},
        {4, (char)20, HUFFMAN_MATCH}, {4, (char)20, HUFFMAN_MATCH},
        {4, (char)20, HUFFMAN_MATCH}, {4, (char)20, HUFFMAN_MATCH},
        {4, (char)20, HUFFMAN_MATCH}, {4, (char)20, HUFFMAN_MATCH},
        {4, (char)20, HUFFMAN_MATCH}, {4, (char)20, HUFFMAN_MATCH},
        {4, (char)20, HUFFMAN_MATCH}, {4, (char)20, HUFFMAN_MATCH},
        {4, (char)20, HUFFMAN_MATCH}, {4, (char)20, HUFFMAN_MATCH},
        // 0010
        {4, (char)21, HUFFMAN_MATCH}, {4, (char)21, HUFFMAN_MATCH},
        {4, (char)21, HUFFMAN_MATCH}, {4, (char)21, HUFFMAN_MATCH},
        {4, (char)21, HUFFMAN_MATCH}, {4, (char)21, HUFFMAN_MATCH},
        {4, (char)21, HUFFMAN_MATCH}, {4, (char)21, HUFFMAN_MATCH},
        {4, (char)21, HUFFMAN_MATCH}, {4, (char)21, HUFFMAN_MATCH},
        {4, (char)21, HUFFMAN_MATCH}, {4, (char)21, HUFFMAN_MATCH},
        {4, (char)21, HUFFMAN_MATCH}, {4, (char)21, HUFFMAN_MATCH},
        {4, (char)21, HUFFMAN_MATCH}, {4, (char)21, HUFFMAN_MATCH},
        // 0011
        {4, (char)23, HUFFMAN_MATCH}, {4, (char)23, HUFFMAN_MATCH},
        {4, (char)23, HUFFMAN_MATCH}, {4, (char)23, HUFFMAN_MATCH},
        {4, (char)23, HUFFMAN_MATCH}, {4, (char)23, HUFFMAN_MATCH},
        {4, (char)23, HUFFMAN_MATCH}, {4, (char)23, HUFFMAN_MATCH},
        {4, (char)23, HUFFMAN_MATCH}, {4, (char)23, HUFFMAN_MATCH},
        {4, (char)23, HUFFMAN_MATCH}, {4, (char)23, HUFFMAN_MATCH},
        {4, (char)23, HUFFMAN_MATCH}, {4, (char)23, HUFFMAN_MATCH},
        {4, (char)23, HUFFMAN_MATCH}, {4, (char)23, HUFFMAN_MATCH},
        // 0100
        {4, (char)24, HUFFMAN_MATCH}, {4, (char)24, HUFFMAN_MATCH},
        {4, (char)24, HUFFMAN_MATCH}, {4, (char)24, HUFFMAN_MATCH},
        {4, (char)24, HUFFMAN_MATCH}, {4, (char)24, HUFFMAN_MATCH},
        {4, (char)24, HUFFMAN_MATCH}, {4, (char)24, HUFFMAN_MATCH},
        {4, (char)24, HUFFMAN_MATCH}, {4, (char)24, HUFFMAN_MATCH},
        {4, (char)24, HUFFMAN_MATCH}, {4, (char)24, HUFFMAN_MATCH},
        {4, (char)24, HUFFMAN_MATCH}, {4, (char)24, HUFFMAN_MATCH},
        {4, (char)24, HUFFMAN_MATCH}, {4, (char)24, HUFFMAN_MATCH},
        // 0101
        {4, (char)25, HUFFMAN_MATCH}, {4, (char)25, HUFFMAN_MATCH},
        {4, (char)25, HUFFMAN_MATCH}, {4, (char)25, HUFFMAN_MATCH},
        {4, (char)25, HUFFMAN_MATCH}, {4, (char)25, HUFFMAN_MATCH},
        {4, (char)25, HUFFMAN_MATCH}, {4, (char)25, HUFFMAN_MATCH},
        {4, (char)25, HUFFMAN_MATCH}, {4, (char)25, HUFFMAN_MATCH},
        {4, (char)25, HUFFMAN_MATCH}, {4, (char)25, HUFFMAN_MATCH},
        {4, (char)25, HUFFMAN_MATCH}, {4, (char)25, HUFFMAN_MATCH},
        {4, (char)25, HUFFMAN_MATCH}, {4, (char)25, HUFFMAN_MATCH},
        // 0110
        {4, (char)26, HUFFMAN_MATCH}, {4, (char)26, HUFFMAN_MATCH},
        {4, (char)26, HUFFMAN_MATCH}, {4, (char)26, HUFFMAN_MATCH},
        {4, (char)26, HUFFMAN_MATCH}, {4, (char)26, HUFFMAN_MATCH},
        {4, (char)26, HUFFMAN_MATCH}, {4, (char)26, HUFFMAN_MATCH},
        {4, (char)26, HUFFMAN_MATCH}, {4, (char)26, HUFFMAN_MATCH},
        {4, (char)26, HUFFMAN_MATCH}, {4, (char)26, HUFFMAN_MATCH},
        {4, (char)26, HUFFMAN_MATCH}, {4, (char)26, HUFFMAN_MATCH},
        {4, (char)26, HUFFMAN_MATCH}, {4, (char)26, HUFFMAN_MATCH},
        // 0111
        {4, (char)27, HUFFMAN_MATCH}, {4, (char)27, HUFFMAN_MATCH},
        {4, (char)27, HUFFMAN_MATCH}, {4, (char)27, HUFFMAN_MATCH},
        {4, (char)27, HUFFMAN_MATCH}, {4, (char)27, HUFFMAN_MATCH},
        {4, (char)27, HUFFMAN_MATCH}, {4, (char)27, HUFFMAN_MATCH},
        {4, (char)27, HUFFMAN_MATCH}, {4, (char)27, HUFFMAN_MATCH},
        {4, (char)27, HUFFMAN_MATCH}, {4, (char)27, HUFFMAN_MATCH},
        {4, (char)27, HUFFMAN_MATCH}, {4, (char)27, HUFFMAN_MATCH},
        {4, (char)27, HUFFMAN_MATCH}, {4, (char)27, HUFFMAN_MATCH},
        // 1000
        {4, (char)28, HUFFMAN_MATCH}, {4, (char)28, HUFFMAN_MATCH},
        {4, (char)28, HUFFMAN_MATCH}, {4, (char)28, HUFFMAN_MATCH},
        {4, (char)28, HUFFMAN_MATCH}, {4, (char)28, HUFFMAN_MATCH},
        {4, (char)28, HUFFMAN_MATCH}, {4, (char)28, HUFFMAN_MATCH},
        {4, (char)28, HUFFMAN_MATCH}, {4, (char)28, HUFFMAN_MATCH},
        {4, (char)28, HUFFMAN_MATCH}, {4, (char)28, HUFFMAN_MATCH},
        {4, (char)28, HUFFMAN_MATCH}, {4, (char)28, HUFFMAN_MATCH},
        {4, (char)28, HUFFMAN_MATCH}, {4, (char)28, HUFFMAN_MATCH},
        // 1001
        {4, (char)29, HUFFMAN_MATCH}, {4, (char)29, HUFFMAN_MATCH},
        {4, (char)29, HUFFMAN_MATCH}, {4, (char)29, HUFFMAN_MATCH},
        {4, (char)29, HUFFMAN_MATCH}, {4, (char)29, HUFFMAN_MATCH},
        {4, (char)29, HUFFMAN_MATCH}, {4, (char)29, HUFFMAN_MATCH},
        {4, (char)29, HUFFMAN_MATCH}, {4, (char)29, HUFFMAN_MATCH},
        {4, (char)29, HUFFMAN_MATCH}, {4, (char)29, HUFFMAN_MATCH},
        {4, (char)29, HUFFMAN_MATCH}, {4, (char)29, HUFFMAN_MATCH},
        {4, (char)29, HUFFMAN_MATCH}, {4, (char)29, HUFFMAN_MATCH},
        // 1010
        {4, (char)30, HUFFMAN_MATCH}, {4, (char)30, HUFFMAN_MATCH},
        {4, (char)30, HUFFMAN_MATCH}, {4, (char)30, HUFFMAN_MATCH},
        {4, (char)30, HUFFMAN_MATCH}, {4, (char)30, HUFFMAN_MATCH},
        {4, (char)30, HUFFMAN_MATCH}, {4, (char)30, HUFFMAN_MATCH},
        {4, (char)30, HUFFMAN_MATCH}, {4, (char)30, HUFFMAN_MATCH},
        {4, (char)30, HUFFMAN_MATCH}, {4, (char)30, HUFFMAN_MATCH},
        {4, (char)30, HUFFMAN_MATCH}, {4, (char)30, HUFFMAN_MATCH},
        {4, (char)30, HUFFMAN_MATCH}, {4, (char)30, HUFFMAN_MATCH},
        // 1011
        {4, (char)31, HUFFMAN_MATCH}, {4, (char)31, HUFFMAN_MATCH},
        {4, (char)31, HUFFMAN_MATCH}, {4, (char)31, HUFFMAN_MATCH},
        {4, (char)31, HUFFMAN_MATCH}, {4, (char)31, HUFFMAN_MATCH},
        {4, (char)31, HUFFMAN_MATCH}, {4, (char)31, HUFFMAN_MATCH},
        {4, (char)31, HUFFMAN_MATCH}, {4, (char)31, HUFFMAN_MATCH},
        {4, (char)31, HUFFMAN_MATCH}, {4, (char)31, HUFFMAN_MATCH},
        {4, (char)31, HUFFMAN_MATCH}, {4, (char)31, HUFFMAN_MATCH},
        {4, (char)31, HUFFMAN_MATCH}, {4, (char)31, HUFFMAN_MATCH},
        // 1100
        {4, (char)127, HUFFMAN_MATCH}, {4, (char)127, HUFFMAN_MATCH},
        {4, (char)127, HUFFMAN_MATCH}, {4, (char)127, HUFFMAN_MATCH},
        {4, (char)127, HUFFMAN_MATCH}, {4, (char)127, HUFFMAN_MATCH},
        {4, (char)127, HUFFMAN_MATCH}, {4, (char)127, HUFFMAN_MATCH},
        {4, (char)127, HUFFMAN_MATCH}, {4, (char)127, HUFFMAN_MATCH},
        {4, (char)127, HUFFMAN_MATCH}, {4, (char)127, HUFFMAN_MATCH},
        {4, (char)127, HUFFMAN_MATCH}, {4, (char)127, HUFFMAN_MATCH},
        {4, (char)127, HUFFMAN_MATCH}, {4, (char)127, HUFFMAN_MATCH},
        // 1101
        {4, (char)220, HUFFMAN_MATCH}, {4, (char)220, HUFFMAN_MATCH},
        {4, (char)220, HUFFMAN_MATCH}, {4, (char)220, HUFFMAN_MATCH},
        {4, (char)220, HUFFMAN_MATCH}, {4, (char)220, HUFFMAN_MATCH},
        {4, (char)220, HUFFMAN_MATCH}, {4, (char)220, HUFFMAN_MATCH},
        {4, (char)220, HUFFMAN_MATCH}, {4, (char)220, HUFFMAN_MATCH},
        {4, (char)220, HUFFMAN_MATCH}, {4, (char)220, HUFFMAN_MATCH},
        {4, (char)220, HUFFMAN_MATCH}, {4, (char)220, HUFFMAN_MATCH},
        {4, (char)220, HUFFMAN_MATCH}, {4, (char)220, HUFFMAN_MATCH},
        // 1110
        {4, (char)249, HUFFMAN_MATCH}, {4, (char)249, HUFFMAN_MATCH},
        {4, (char)249, HUFFMAN_MATCH}, {4, (char)249, HUFFMAN_MATCH},
        {4, (char)249, HUFFMAN_MATCH}, {4, (char)249, HUFFMAN_MATCH},
        {4, (char)249, HUFFMAN_MATCH}, {4, (char)249, HUFFMAN_MATCH},
        {4, (char)249, HUFFMAN_MATCH}, {4, (char)249, HUFFMAN_MATCH},
        {4, (char)249, HUFFMAN_MATCH}, {4, (char)249, HUFFMAN_MATCH},
        {4, (char)249, HUFFMAN_MATCH}, {4, (char)249, HUFFMAN_MATCH},
        {4, (char)249, HUFFMAN_MATCH}, {4, (char)249, HUFFMAN_MATCH},
        // 111100
        {6, (char)10, HUFFMAN_MATCH}, {6, (char)10, HUFFMAN_MATCH},
        {6, (char)10, HUFFMAN_MATCH}, {6, (char)10, HUFFMAN_MATCH},
        // 111101
        {6, (char)13, HUFFMAN_MATCH}, {6, (char)13, HUFFMAN_MATCH},
        {6, (char)13, HUFFMAN_MATCH}, {6, (char)13, HUFFMAN_MATCH},
        // 111110
        {6, (char)22, HUFFMAN_MATCH}, {6, (char)22, HUFFMAN_MATCH},
        {6, (char)22, HUFFMAN_MATCH}, {6, (char)22, HUFFMAN_MATCH},
        // 111111
        {6, (char)0, HUFFMAN_FAILURE}, {6, (char)0, HUFFMAN_FAILURE},
        {6, (char)0, HUFFMAN_FAILURE}, {6, (char)0, HUFFMAN_FAILURE},
    },
};
