with Ada.Exceptions;
with Interfaces.C.Strings;
with Text_io; use Text_io;

package body SysUtils is

-- This method generally works if we make sure that the system 
-- command sent to the "shell" proc is valid for the system.

   procedure Shell ( Str: in string;  Success: out boolean ) is
     stat: integer;
     sptr: interfaces.c.strings.chars_ptr;

     --returns zero if Ok:
     function SystemShell
       ( sptr: interfaces.c.strings.chars_ptr ) return integer;

     pragma Import ( convention    => C,
                     entity        => SystemShell,
                     external_name => "system" );
   begin --shell

     success:=false;

     sptr := interfaces.c.strings.new_string( str );
     stat := SystemShell ( sptr );
     interfaces.c.strings.free ( sptr );

     success := (stat=0);

   exception
      when the_error: others =>
         put_line("SysUtils: " &
           Ada.Exceptions.Exception_Information(the_error)
         );


   end shell;

end SysUtils;
