--
-- Copyright (C) 2021  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with interfaces.c;

package globals is

	use interfaces.c;

	screenwidth : constant integer := 80;
	screenheight : constant integer := 24;

	playerwidth : constant integer := 5;
	playerposy : constant integer := screenheight-2; -- 22

	bunkerwidth: constant integer := screenwidth;
	bunkerheight: constant integer := 4;
	bunkerX: constant integer := 0;
	bunkerY: constant integer := screenheight-8; -- 16

	aliens_max_number_x : constant integer := 10;
	aliens_max_number_y : constant integer :=  5;

	ufowidth : constant integer := 5;
	ufoposy : constant integer :=  0;

	myshoot, death,
	mykill,myUfoKill,vad1,vad2,vad3,vad4, intro : interfaces.c.int := -1;

	shootThreshold,
	weite, level,
	lives, score, skill_level: integer := 0;

	vad: integer := 3;
	missedShots, shipnum: integer := 0;

	finalshotx, finalshoty,
	finalaposx, finalaposy: integer; --debug only

	alienshot_counter : integer := 0;


	---------- game timing parameters: ----------

	-- bounds for parm that controls alien move-speed:
	weiteHi: constant integer := 30; --starting weite
	weiteLo: constant integer := weiteHi/2; --ending weite

-- tick=0.025: works Ok with weite=20, skip=1
-- tick=0.02:  works Ok with weite=30, skip=3 (flicker@skip=1)

	-- seconds between  moves...
	-- critical gameplay setting...
	--tick : constant duration := 0.025; -- 1/40 sec (40 fps)
	tick : constant duration := 0.02; -- 1/50 sec (50 fps)
	--tick : constant duration := 0.01; -- waay to hard
	-- we want aliens to move about once each second @ level 1,
	-- and the sound to match, BUT the tick is much smaller.
	-- "globals.weite" controls how many ticks between alien steps.
	-- Finally, I reduce weite each step down (closer)
	-- to increase the alien speed.

	--------- alien numbers of missiles fired; lower=>more
	shootHi: constant integer := 100; --80 60 make 1st level easier!
	shootLo: constant integer := shootHi/2;
	shootInc: constant integer := 10; --5;

procedure myassert( condition : boolean;  flag: integer:=0 );

end globals;

