--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with ada.numerics.float_random;

with globals;
with aliens;

with snd4ada;


package body ufo is

	G : Ada.Numerics.Float_Random.Generator;


	--type uforec is record
	--	posX,posY: integer;
	--end record;

	--ufo: uforec;
	fShowUfo: integer := 0;

	procedure ufoReset is
	begin

		--ufoClear(ufo.posX,ufo.posY);
		fShowUfo:=0;
		ufo.posY := globals.ufoposy;
		ufo.posX := globals.screenwidth - globals.ufowidth;

	end ufoReset;


	procedure ufoMove( posX: integer ) is
	begin
		--ufoClear(ufo.posX,ufo.posY);
		ufo.posX := posX;
		--ufoRefresh;
		--ufoDisplay(ufo.posX,ufo.posY);
	end ufoMove;


	function ufoShowUfo return integer is
		rand01: float;
	begin
		if aliens.aliens.posY > 0 and fShowUfo=0 then
			rand01 := Ada.Numerics.Float_Random.Random(G); -- [0..1]
			if rand01 < 0.005 then -- 1/2% of time
				fShowUfo:=1;
			end if;
		end if;
		return fShowUfo;
	end ufoShowUfo;


	procedure ufoMoveLeft is
	begin
		if ufo.posX > 1 then
			ufoMove(ufo.posX-1);
		else
			ufoReset;
		end if;
	end ufoMoveLeft;


	function ufoHitCheck( shotX, shotY: integer ) return integer is
		fUfoWasHit : integer := 0;
	begin
		if shotY=globals.ufoposy then
			if shotX>=ufo.posX and shotX<=ufo.posX+globals.ufowidth-1 then
				ufoReset;
				fUfoWasHit:=1;
				--snd4ada.playSnd(globals.myUfoKill);
			end if;
		end if;
		return fUfoWasHit;
	end ufoHitCheck;

end ufo;

