
with ada.directories;
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
with Interfaces.C.Pointers;
with interfaces.c.strings;

with ada.unchecked_conversion;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;
with ada.numerics.generic_elementary_functions;
with ada.numerics.discrete_random;

with text_io;

with ada.calendar;

with ada.strings.fixed;

with sysutils;

with GNATCOLL.Terminal;  use GNATCOLL.Terminal;






procedure cpac is

	subtype dirtype is integer range 1..4;
	package random_dir is new ada.numerics.discrete_random(dirtype);
	gen : random_dir.generator;

	use Ada.Strings.Unbounded;
	use Ada.Strings.Unbounded.Text_IO;
	use text_io;
	use interfaces.c;
	use interfaces.c.strings;

	use ada.calendar;


	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );
	use fmath;

	package myint_io is new text_io.integer_io(integer);



	--pausehalf : constant duration := 0.5;
	pause1sec : constant duration := 1.0;
	--pause2sec : constant duration := 2.0;
	pause3sec : constant duration := 3.0;

	eks, endgame, collisionpause, 
		userpause, userexit  : boolean := false;



	tick : constant duration := 0.15; --0.2; 
	-- seconds between pacman moves...
	-- critical gameplay setting...
	-- reduce for faster gameplay

	levelpause : constant duration := 3.0; -- seconds between levels

	powerfade: constant integer := 55; 
	--steps of invincibility after powerup

	freelife : integer := 1000;
	points   : integer := 0; --score
	lives    : integer := 3;
	howslow  : integer := 3;

	-- requires windowsize at least 57x35:
	level_width : constant integer := 28;
	level_height : constant integer := 29;

	nobj : constant integer := 5; -- 4ghosts + pacman


	numlev: constant integer := 9;
	shortname: constant array(1..numlev) of string(1..11) 
	:=(
		"level01.dat",
		"level02.dat",
		"level03.dat",
		"level04.dat",
		"level05.dat",
		"level06.dat",
		"level07.dat",
		"level08.dat",
		"level09.dat");

	levdir: constant string(1..7) := "Levels/";

	leveldata : array(1..level_height,1..level_width) of integer
		:= (others=>(others=>0));

	loc : array(1..nobj,1..2) of integer --location ghosts/pacman
		:= (others=>(others=>0));
		
	dir : array(1..nobj,1..2) of integer --direction ghosts/pacman
		:= (others=>(others=>0));

	startingpoints : array(1..nobj,1..2) of integer --location ghosts/pacman
		:= (others=>(others=>0));

	invincible, food, levelnumber, ghostsinarow, tleft
	: integer := 0;


	pending: boolean := false;





procedure myassert( condition : boolean;  flag: integer:=0 ) is
begin
  if condition=false then
  		put("ASSERTION Failed!  ");
		if flag /= 0 then
			put_line( "@ " & integer'image(flag) );
		end if;
		new_line;
  		raise program_error;
  end if;
end myassert;







procedure loadlevel( lev: integer ) is
	fileid : text_io.file_type;
	ini, nlev: integer;
begin

	-- reset defaults
	dir(1,1):= 1;  dir(1,2):= 0;
	dir(2,1):=-1;  dir(2,2):= 0;
	dir(3,1):= 0;  dir(3,2):=-1;
	dir(4,1):= 0;  dir(4,2):= 1;
	dir(5,1):= 0;  dir(5,2):= 0;

	text_io.open(fileid,text_io.in_file,levdir&shortname(lev));

	for row in 1..level_height loop
	for col in 1..level_width loop
		myint_io.get(fileid, ini);
		leveldata(row,col):=ini;

		-- 0 => normal
		-- 1 => wall
		-- 2 => pellet
		-- 3 => powerup
		-- 4 => ghostwall
		-- 5 =>
		-- 6 =>
		-- 7 =>
		-- 8 =>
		-- 9 =>

		if ini=2 then food:=food+1; end if;

		if ini>=5 and ini<=9 then
			loc(ini-4,1):=row;
			loc(ini-4,2):=col;
			leveldata(row,col):=0;
		end if;


	end loop;
	end loop;
	myint_io.get(fileid, nlev);
	myassert( nlev = lev );
	text_io.close(fileid);

	for a in 1..nobj loop
		startingpoints(a,1):=loc(a,1);
		startingpoints(a,2):=loc(a,2);
	end loop;
	
end loadlevel;









procedure draw ( done : boolean := false );


procedure checkcollision is
	nextime : Time := clock+pause1sec;
begin

for a in 1..4 loop -- check each ghost (pacman: a=5)

	if 

		( loc(a,1)=loc(5,1) and loc(a,2)=loc(5,2) )  --g-cell versus current p-cell
		or 
		( loc(a,1)=loc(5,1)+dir(5,1) and loc(a,2)=loc(5,2)+dir(5,2) ) --next p-cell
		or
		( loc(a,1)+dir(a,1)=loc(5,1) and loc(a,2)+dir(a,2)=loc(5,2) )  --next g-cell

	then --ghost a collides w/pacman

		-- do this here IF we want pacman to stop even when invincible:
		--collisionpause:=true;
		--pending:=false; --empty move queue
		--dir(5,1):= 0;  dir(5,2):= 0; --pacman stops


		if invincible=1 then
			points := points + ghostsinarow*20;
			ghostsinarow := ghostsinarow*2;

			--reset ghost pos
			loc(a,1):=startingpoints(a,1);
			loc(a,2):=startingpoints(a,2);
		else -- pacman is vulnerable, dies

			-- perhaps these 2 statements should go here instead:
			collisionpause:=true;
			pending:=false; --empty move queue
			dir(5,1):= 0;  dir(5,2):= 0; --pacman stops

			--perhaps adjust display from "C" to "X"
			lives:=lives-1;
			eks:=true;

			if lives=-1 then 
				userexit:=true;
				endgame:=true;

			else --game not over...

				--for a in 1..5 loop
				for a in 1..4 loop -- lets leave pacman where he is
					loc(a,1):= startingpoints(a,1);
					loc(a,2):= startingpoints(a,2);
				end loop;

				-- reset defaults
				dir(1,1):= 1;  dir(1,2):= 0;
				dir(2,1):=-1;  dir(2,2):= 0;
				dir(3,1):= 0;  dir(3,2):=-1;
				dir(4,1):= 0;  dir(4,2):= 1;

			end if;
		end if; --invincible
	end if;

end loop; -- for each ghost

end checkcollision;







procedure moveghosts is
	checksides : array(1..6) of integer := (others=>0);
	b,c, slowerghosts, pr,pc, row,col, rdir,cdir, tmp : integer := 0;
begin

	if invincible=1 then
		slowerghosts:=slowerghosts+1;
		if slowerghosts>howslow then slowerghosts:=0; end if;
	end if;

	if invincible=0 or slowerghosts<howslow then

		pr:=loc(5,1);  pc:=loc(5,2); --pacman

	for a in 1..4 loop -- thru each ghost

		row:=loc(a,1);  rdir:=dir(a,1);
		col:=loc(a,2);  cdir:=dir(a,2);

		--switch sides?
		if    row=1 and dir(a,1)=-1 then loc(a,1):=level_height;
		elsif row=level_height and dir(a,1)=1 then loc(a,1):=1;
		elsif col=1 and dir(a,2)=-1 then loc(a,2):=level_width;
		elsif col=level_width and dir(a,2)=1 then loc(a,2):=1;

		else --pacman within normal area

			for b in 1..4 loop checksides(b):=0; end loop;

			if row=level_height then tmp:=1; else tmp:=row+1; end if;
			if leveldata(tmp,col) /= 1 then checksides(1):=1; end if;

			if row=1 then tmp:=level_height; else tmp:=row-1; end if;
			if leveldata(tmp,col) /= 1 then checksides(2):=1; end if;

			if col=level_width then tmp:=1; else tmp:=col+1; end if;
			if leveldata(row,tmp) /= 1 then checksides(3):=1; end if;

			if col=1 then tmp:=level_width; else tmp:=col-1; end if;
			if leveldata(row,tmp) /= 1 then checksides(4):=1; end if;

			-- dont do 180 unless we have to
			c:=0; 
			for b in 1..4 loop 
				if checksides(b)=1 then c:=c+1; end if; 
			end loop;

			if c>1 then
				if    rdir= 1 then checksides(2):=0;
				elsif rdir=-1 then checksides(1):=0;
				elsif cdir= 1 then checksides(4):=0;
				elsif cdir=-1 then checksides(3):=0;
				end if;
			end if; --c>1

			c:=0;
			loop

				b := random_dir.random(gen); -- 1..4


				-- tend to mostly chase pacman if he is vulnerable, or else run away
				if checksides(b)=1 then
					if    b=1 then dir(a,1):= 1; dir(a,2):= 0;
					elsif b=2 then dir(a,1):=-1; dir(a,2):= 0;
					elsif b=3 then dir(a,1):= 0; dir(a,2):= 1;
					elsif b=4 then dir(a,1):= 0; dir(a,2):=-1; end if;
				else
					if invincible=0 then --chase pacman

						if    pr>row and checksides(1)=1 then
							dir(a,1):= 1; dir(a,2):= 0; c:=1;
						elsif pr<row and checksides(2)=1 then
							dir(a,1):=-1; dir(a,2):= 0; c:=1;
						elsif pc>col and checksides(3)=1 then
							dir(a,1):= 0; dir(a,2):= 1; c:=1;
						elsif pc<col and checksides(4)=1 then
							dir(a,1):= 0; dir(a,2):=-1; c:=1;
						end if;

					else -- runaway from pacman

						if    pr>row and checksides(2)=1 then
							dir(a,1):=-1; dir(a,2):= 0; c:=1;
						elsif pr<row and checksides(1)=1 then
							dir(a,1):= 1; dir(a,2):= 0; c:=1;

						elsif pc>col and checksides(4)=1 then
							dir(a,1):= 0; dir(a,2):=-1; c:=1;
						elsif pc<col and checksides(3)=1 then
							dir(a,1):= 0; dir(a,2):= 1; c:=1;
						end if;

					end if;
				end if;

				exit when checksides(b)/=0 or c/=0;
			end loop;

			--move ghost
			loc(a,1):= loc(a,1)+dir(a,1);
			loc(a,2):= loc(a,2)+dir(a,2);

		end if;


	end loop; -- for a

	end if; --invincible=0 or...

end moveghosts;






itime : integer := 0;

procedure movepacman is
	prow,pcol, prdir,pcdir, posval : integer;
begin

	prow:=loc(5,1); prdir:=dir(5,1);
	pcol:=loc(5,2); pcdir:=dir(5,2);

--switch sides (torroidal universe)
if    prow=1 and prdir=-1 then loc(5,1):=level_height;
elsif prow=level_height and prdir=1 then loc(5,1):=1;
elsif pcol=1 and pcdir=-1 then loc(5,2):=level_width;
elsif pcol=level_width  and pcdir=1 then loc(5,2):=1;

else -- move pacman normally

	-- tentative update:
	prow:=prow+dir(5,1);
	pcol:=pcol+dir(5,2);
	posval:=leveldata(prow,pcol);
		-- 0 => normal
		-- 1 => wall
		-- 2 => pellet
		-- 3 => powerup, fruit
		-- 4 => ghostwall

	-- if hitting wall, move back
	if posval=1 or posval=4 then
		null;
	else
		--proceed with update
		loc(5,1):=prow;
		loc(5,2):=pcol;
	end if;

end if;

	posval:=leveldata( loc(5,1), loc(5,2) );
	if posval=2 then --pellet
		leveldata( loc(5,1), loc(5,2) ) := 0;
		points := points+1;
		food := food-1;
	elsif posval=3 then --powerup
		leveldata( loc(5,1), loc(5,2) ) := 0;
		invincible:=1;
		if ghostsinarow=0 then ghostsinarow:=1; end if;
		itime:=powerfade-levelnumber;
	end if;

	
	if invincible=1 then
		itime:=itime-1;
	end if;

	-- has invincibility expired yet?
	if itime<1 then
		invincible:=0;
		ghostsinarow:=0;
	end if;


end movepacman;






procedure draw ( done : boolean := false ) is

	info: terminal_info;

	chr: character;
	val, pr,pc, row,col: integer;
	Ok: boolean;


	-- m=magenta, y=yellow, r=red, g=grey, 
	-- b=blue, k=black, n=green, c=cyan
	type enum is (m,y,r,g,b,k,n,c,w,x); -- x => not yet set
	colr : enum := x;

	nextime : Time := clock;

begin

	info.init_for_stdout(auto);

	SysUtils.Shell("clear", Ok); -- erase-terminal


   Info.Set_Color (style=>bright);
	Info.Set_Bg(black);
	colr:=x;

	--Info.Set_Fg(red); colr:=r;
	--Info.Set_Fg(magenta); colr:=m;
	--Info.Set_Fg(green); colr:=n;
	--Info.Set_Fg(cyan); colr:=c;


	for rr in 1..level_height loop

		for cc in 1..level_width loop

			val:=leveldata(rr,cc);
			case val is
				when 0 => 
					chr:=' ';
				when 1 => 
					chr:='#'; --wall
					if colr/=b then
						info.set_fg(blue); colr:=b;
					end if;
				when 2 => 
					chr:='.'; --food
					if colr/=g then
						info.set_fg(grey); colr:=g;
					end if;
				when 3 => 
					chr:='*'; --powerup
					if colr/=g then
						info.set_fg(grey); colr:=g;
					end if;
				when 4 => 
					chr:='+'; --ghostwall
					if colr/=c then
						info.set_fg(cyan); colr:=c;
					end if;
				when others => 
					null;
			end case;

			pr:=loc(5,1);
			pc:=loc(5,2);
			if pr=rr and pc=cc then

				if colr/=y then
					info.set_fg(yellow); colr:=y;
				end if;

				if eks then
					chr:='X';
					eks:=false;
				else
					chr:='C';
				end if;
			else

				--ghosts
				for k in 1..nobj-1 loop
					row:=loc(k,1);
					col:=loc(k,2);
					if row=rr and col=cc then

						if invincible=0 then -- ghosts are killers
							chr:='&';
							if colr/=r then
								info.set_fg(red); colr:=r;
							end if;
						else -- here, ghosts are afraid
							chr:='?';
							if colr/=n then
								info.set_fg(green); colr:=n;
							end if;
						end if;

					end if;
				end loop;

			end if;

			put(" " & chr);

		end loop; -- col
		new_line;

	end loop; -- row
	new_line;

   Info.Set_Color (Standard_Output, Style => Reset_All);



	put_line(" FreeLife: "&integer'image(freelife));
	put_line(" Lives: "&integer'image(lives));
	put_line(" Level: "&integer'image(levelnumber));
	put_line(" Score: "&integer'image(points));
	if done then
		put_line(" Level Complete...loading next level.");
	elsif userpause then
		put_line(" Game Paused...");
		put_line(" q=quit;  p= pause-toggle;  c= toggle faster colors");
	elsif endgame then
		put_line(" Sorry, you lose!  Game Over.");
	end if;

	if collisionpause then
		collisionpause:=false;
		if lives=-1 then
			nextime:=nextime+pause3sec;
		else
			nextime:=nextime+pause1sec;
		end if;
		delay until nextime;
	end if;


end draw;





function isvalid(ch: character) return boolean is
	ok: boolean := false;
begin
	case ch is
		when 'A'|'B'|'C'|'D' => ok:=true;
		when 'w'|'s'|'d'|'a' => ok:=true;
		when 'i'|'k'|'l'|'j' => ok:=true;
		when     'x'|'q'|'p' => ok:=true;
		when others => ok:=false;
	end case;
	return ok;
end;


procedure handle_key_down( ch: character; ok: out boolean ) is
	pr,pc, xr,xc : integer;
begin -- leveldata:  1=>wall, 4=>ghostwall

	ok:=false;

	pr:=loc(5,1);
	pc:=loc(5,2);

-- note that arrow keys typically produce chars in {up=A,dn=B,rt=C,lf=D}

	case ch is


		when 'A' | 'w' | 'i'  => --up

			if pr<=1 then xr:=level_height; else xr:=pr-1; end if;
			if leveldata(xr,pc) /= 1 and leveldata(xr,pc) /=4 then
				dir(5,1):=-1; dir(5,2):=0;
				ok:=true;
			end if;


		when 'B' | 's' | 'k' =>	--dn

			if pr>=level_height then xr:=1; else xr:=pr+1; end if;
			if leveldata(xr,pc) /= 1 and leveldata(xr,pc) /=4 then
				dir(5,1):=+1; dir(5,2):=0;
				ok:=true;
			end if;


		when 'D' | 'a' | 'j' =>	--lf

			if pc<=1 then xc:=level_width; else xc:=pc-1; end if;
			if leveldata(pr,xc) /=1 and leveldata(pr,xc) /=4 then
				dir(5,1):=0; dir(5,2):=-1;
				ok:=true;
			end if;


		when 'C' | 'd' | 'l' =>	--rt

			if pc>=level_width then xc:=1; else xc:=pc+1; end if;
			if leveldata(pr,xc) /=1 and leveldata(pr,xc) /=4 then
				dir(5,1):=0; dir(5,2):=+1;
				ok:=true;
			end if;


		when 'x' | 'q' =>	userexit:=true; ok:=true;
		when 'p' => userpause:=not userpause; ok:=true; -- toggle


		-- messages shown here are immediately erased
		-- unless we pause for user input...
		when others => null;

	end case;


end handle_key_down;






	ich, qch: character;
	digested, avail : boolean := false;

	nextime : Time := clock+tick;

begin --cpac

--randomize
random_dir.reset(gen); --time-dependent randomization


-- requires windowsize at least 57x35:


for levelnumber in 1..numlev loop

	loadlevel(levelnumber);

	Draw;

	if levelnumber = 1 then
		put_line(" ...needs a window with 57 columns X 35 rows...");
	end if;

	-- begin countdown:
	put(" Ready... 5");
	for i in reverse 0..4 loop
		nextime:=nextime+pause1sec;  
		delay until nextime;
		put(integer'image(i));
	end loop;
	nextime:=nextime+pause1sec;  
	delay until nextime;


	-- to try and ameliorate primitive timing...
	-- insert qch as a pending move;
	-- keep trying to use it until either
	-- a) it gets used, or
	-- b) a new "ch" replaces it, or
	-- c) pacman loses a life.


	pending:=false;
   while not userexit and food>0 loop -- main event loop begin

		avail:=false;

		if not userpause then
			movepacman;
			moveghosts; 
			checkcollision;
			if points>freelife then
				lives:=lives+1;
				freelife:=freelife*2;
			end if;
		end if;
		draw;


		get_immediate(ich, avail);
		if avail and then isvalid(ich) then --enqueue new user command
			qch:=ich;
			pending:=true;
		end if;

		if pending then --deal with most recent user command
			handle_key_down(qch,digested);
			pending:= not digested; --feed again, if need be
		end if;


		-- this regulates normal timing:
		nextime:=nextime+tick;  delay until nextime; --update timer


		get_immediate(ich, avail);
		if avail and then isvalid(ich) then --enqueue new user command
			qch:=ich;
			pending:=true;
		end if;

		if pending then --deal with most recent user command
			handle_key_down(qch,digested);
			pending:= not digested; --feed again, if need be
		end if;



   end loop; -- main event loop end -------------------

	exit when userexit or endgame; --quit

	exit when food>0; --Level Failure

	draw(done=>true); --Completed this Level

	if levelnumber < 9 then
		nextime:=nextime+levelpause;  
		delay until nextime; --update timer
	end if;

end loop; -- outer for levelnumber

end cpac;

