/*
	This implementation of splay trees came from 
	Cedric Verstraeten (thank you Cedric)

	...although I had read about them in 1985 in:
--
-- Journal of the A.C.M., July 1985,
-- Vol. 32, No. 3, pg. 652, library call # QA 76 A77
--
	and was amazed at their properties.
*/



#ifndef __SPLAYTREE
#define __SPLAYTREE
#include <cstdlib>
#include <iostream>
#include <queue>
#include "binsearchtree.h"
using namespace std;
using std::ostream;


// fastrgv note:  class Key can be any class for which 
// a) the operator "<" is defined
// AND
// b) the operator "!=" is defined

template <class Key,class Data>
class SplayTree : public BinSearchTree<Key,Data> {
public:
	
	// check if position is left child from parent or not
	bool isLeftChild(BinNode<Key,Data>*& position, BinNode<Key,Data>*& parent){
		return (position == parent->left.k);
	};
	
	// splay operation
	void splay(BinTree<Key,Data>*& position, BinNode<Key,Data>*& parent, BinTree<Key,Data>*& deBinTree){
		// Not @ root 
		while(parent!=0)
		{
			//Main 1: rotate root
			// 
			if(parent->parent==0)
			{
				// Symmetrie left child from root
				// Zig
				deBinTree->roteer(!isLeftChild(position->k,parent));
				parent = 0;
			}

			//Main 2: rotate intern
			else {
				
				BinNode<Key,Data> * grandparentcpy = parent->parent->parent;
				BinTree<Key,Data> * grootparent = 0;
				
				if(grandparentcpy==0)
					grootparent = deBinTree;
				else{	
					if(isLeftChild(parent->parent,grandparentcpy))
						grootparent = &(grandparentcpy->left);
					else
						grootparent = &(grandparentcpy->right);
				}
				
				// Symmetrie Parent left child from grandparent
				if(isLeftChild(parent,parent->parent))
				{
					//
					// Main 2A: if left child from parent
					// ZigZig
					//
					if(isLeftChild(position->k,parent)){	
						// if mag weg als deBinTree probleem opgelost
						grootparent->roteer(false);
						grootparent->roteer(false);
					}
					//
					// Main 2B: if right child from parent
					// ZigZag
					//
					else {
						parent->parent->left.roteer(true);	
						grootparent->roteer(false);
					}
				}
				
				
				// Symmetrie Parent right child from grandparent
				else {
					//
					// Main 2A: if left child from parent
					// ZigZag
					//
					if(isLeftChild(position->k,parent)){
						parent->parent->right.roteer(false);
						grootparent->roteer(true);
					}
					//
					// Main 2B: if right child from parent
					// ZigZig
					//
					else {
						grootparent->roteer(true);
						grootparent->roteer(true);
					}
				}
				
				// replace for while
				position = grootparent;	
				parent = grootparent->k->parent;

			}
		}
	};

	virtual void insert(const Key& key,const Data& data){
	    BinTree<Key,Data>* position;
	    BinNode<Key,Data>* parent;
	    this->searchPosition(key,position,parent);
	    if (position->k == 0){
	        position->k=new BinNode<Key,Data>(key,data);
	        position->k->parent=parent;
	    }
		BinTree<Key,Data>* deBinTree = &(this->deBinTree);
		splay(position,parent,deBinTree);
	}



	virtual void find(const Key& key, Data& data, bool&found){
	    BinTree<Key,Data>* position;
	    BinNode<Key,Data>* parent;
	    this->searchPosition(key,position,parent);
	    if (position->k != 0){
			  data = position->k->data;
			  found=true;
	    }
		 else found=false;

		// I need to research what to do if NOT found...
		// ...do we still splay?  NO

		if(found) {
			BinTree<Key,Data>* deBinTree = &(this->deBinTree);
			splay(position,parent,deBinTree);
		}
	}


/*
	virtual void find_and_set_data(const Key& key, Data indata, bool&found){
	    BinTree<Key,Data>* position;
	    BinNode<Key,Data>* parent;
	    this->searchPosition(key,position,parent);
	    if (position->k != 0){
			  position->k->data=indata;
			  found=true;
	    }
		 else found=false;

		if( found ) {
			BinTree<Key,Data>* deBinTree = &(this->deBinTree);
			splay(position,parent,deBinTree);
		}
	}
*/


};

#endif

