/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.primitives.Ints;
import java.util.Comparator;

public abstract class ComparisonChain {
    private static final ComparisonChain ACTIVE = new ComparisonChain(){

        @Override
        public ComparisonChain compare(Comparable<?> left, Comparable<?> right) {
            return this.classify(left.compareTo(right));
        }

        @Override
        public <T> ComparisonChain compare(T left, T right, Comparator<T> comparator) {
            return this.classify(comparator.compare(left, right));
        }

        @Override
        public ComparisonChain compare(int left, int right) {
            return this.classify(Ints.compare(left, right));
        }

        ComparisonChain classify(int result) {
            return result < 0 ? LESS : (result > 0 ? GREATER : ACTIVE);
        }

        @Override
        public int result() {
            return 0;
        }
    };
    private static final ComparisonChain LESS = new InactiveComparisonChain(-1);
    private static final ComparisonChain GREATER = new InactiveComparisonChain(1);

    private ComparisonChain() {
    }

    public static ComparisonChain start() {
        return ACTIVE;
    }

    public abstract ComparisonChain compare(Comparable<?> var1, Comparable<?> var2);

    public abstract <T> ComparisonChain compare(T var1, T var2, Comparator<T> var3);

    public abstract ComparisonChain compare(int var1, int var2);

    public abstract int result();

    private static final class InactiveComparisonChain
    extends ComparisonChain {
        final int result;

        InactiveComparisonChain(int result) {
            this.result = result;
        }

        @Override
        public ComparisonChain compare(Comparable<?> left, Comparable<?> right) {
            return this;
        }

        @Override
        public <T> ComparisonChain compare(T left, T right, Comparator<T> comparator) {
            return this;
        }

        @Override
        public ComparisonChain compare(int left, int right) {
            return this;
        }

        @Override
        public int result() {
            return this.result;
        }
    }
}

