/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.res.decoder.AXmlResourceParser;
import java.util.regex.Pattern;

public class AndroidManifestResourceParser
extends AXmlResourceParser {
    private static final Pattern PATTERN_NUMERIC_STRING = Pattern.compile("\\s?\\d+");

    @Override
    public String getAttributeValue(int index) {
        String value = super.getAttributeValue(index);
        if (!this.isNumericStringMetadataAttributeValue(index, value)) {
            return value;
        }
        return "\\ " + super.getAttributeValue(index).trim();
    }

    private boolean isNumericStringMetadataAttributeValue(int index, String value) {
        return "meta-data".equalsIgnoreCase(super.getName()) && "value".equalsIgnoreCase(super.getAttributeName(index)) && super.getAttributeValueType(index) == 3 && PATTERN_NUMERIC_STRING.matcher(value).matches();
    }
}

