#version 330 core

// fragment shader for island palms, grasses

in vec2 UV;

in vec4 aPos;
in float dist2obj;

out vec4 color;

uniform sampler2D myTextureSampler;
uniform int darkness; // 0...4=darkest (bkgd)
const vec4 night = vec4(0.0,0.0,0.0,1.0);




//////// insert 20dec17 begin /////////////////////////////////////
uniform int fogcolr=1; //  0=>noFog, 1=>white, 2=>brownish, 3=>purple, 4=>gray
uniform int foglevl=0; // 0=>noFog, 1=>Fog

const vec4 vFogColor=vec4(0.7,0.7,0.7,1.0); //normal white
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brown
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purple
//////// insert 20dec17 end /////////////////////////////////////



const float fStart=0.0;
const float fEnd=12.0; // normal fog

float getFogFactor(float rng)
{

	float fResult = (fEnd-rng)/(fEnd-fStart);
	
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}



// this is for palms, grasses, bamboo & seaweed


uniform float mytime;
uniform int palmID; // IF needed
// 1..2 = shortPalms
//    3 = FatPalm
// 4..8 = tallPalm
// 9... = bamboo+grasses


void main(){

	//default method:
	//color = texture( myTextureSampler, UV).rgba;

	// alternate method:
	// these distortions look promising...
	const float twopi=6.2831853;
	float u0=UV.x; //horz 0..1
	float v0=UV.y; //vert 0..1

	//cylindrical radius from Y-axis:
	float cylrad=abs(2.0*u0-1.0); //abs(-1..+1)=0..1

	//spherical radius for palms
	float uc = 0.5;   // horizontal centroid
	float tvc = 0.85; // TallPalm vertical centroid
	float fvc = 0.75; // short+fat vertical centroid
	vec2 tal = vec2((u0-uc)/0.5, (v0-tvc)/(1.-tvc));
	vec2 fat = vec2((u0-uc)/0.5, (v0-fvc)/(1.-fvc));
	float trad = length(tal); //0..1..5
	float frad = length(fat); //0..1..3


// this is pretty good but one still
// needs a cylindrical factor on top
// of the spherical one:
	float fcyl = (1.+cylrad)*0.5; // 0.5 ... 1.0

	const float delta=0.001; //amplitude
	float a1 = v0*u0*twopi; //angle
	a1 *= 3.0; //granularity (90=leaf, 3=branch)
	a1 += 3.0*mytime; //+time-dep=freq*time
	float dd = cos(a1)*delta; //zero-mean noise

if (palmID<=3) //Fat or Short
{
	if (frad>1.0) // trunk: no additional motions
		color = texture( myTextureSampler, UV).rgba;
	else if (v0>fvc) // near top
	{
		float u3 = u0 + dd*frad;
		u3 += 5.*dd*(v0-fvc)/(1.-fvc); //extra dH @ top
		float v3 = v0 + dd*frad;
		vec2 uv = vec2(u3,v3);
		color = texture( myTextureSampler, uv).rgba;
	}
	else
	{
		float u3 = u0 + dd*frad*fcyl;
		float v3 = v0 + dd*frad*fcyl;
		vec2 uv = vec2(u3,v3);
		color = texture( myTextureSampler, uv).rgba;
	}
}
else if (palmID<=8) //TallPalm
{
	if (trad>1.0) // trunk: no additional motions
		color = texture( myTextureSampler, UV).rgba;
	else if (v0>tvc) //near top
	{
		float u3 = u0 + dd*trad;
		u3 += 5.*dd*(v0-tvc)/(1.-tvc); //extra dH @ top
		float v3 = v0 + dd*trad;
		vec2 uv = vec2(u3,v3);
		color = texture( myTextureSampler, uv).rgba;
	}
	else
	{
		float u3 = u0 + dd*trad*fcyl;
		float v3 = v0 + dd*trad*fcyl;
		vec2 uv = vec2(u3,v3);
		color = texture( myTextureSampler, uv).rgba;
	}
}
else //bamboo or grasses
{

	float u3 = u0; // + 0.5*dd*cylrad;

	if( v0>0.8 )
		u3 += 5.*dd*(v0-0.8)/(1.-0.8); //extra dH @ top

	float v3 = v0 + dd*cylrad; //reduce@trunk
	vec2 uv = vec2(u3,v3);
	color = texture( myTextureSampler, uv).rgba;

}


	float df=0;
	if( darkness < 3 ) df=0.0;
	else if( darkness==3 ) df=0.3;
	else if( darkness==4 ) df=0.6;
	float asave=color.a;
	color = mix(color, night, df);
	color.a = asave;
	if( color.a < 0.1 ) discard;


	if(foglevl>0) {

		const float yc=-1.0;
		float dist = exp(-1.0*abs(aPos.y-yc)) * dist2obj;

		if( fogcolr==4 )
			color = mix(color,  vDfogColor, getFogFactor(dist)); //gray
		else if( fogcolr==3 )
			color = mix(color, vMystColor, getFogFactor(dist)); //purple
		else if( fogcolr==2 )
			color = mix(color, vSootColor, getFogFactor(dist)); //brown
		else if( fogcolr==1 )
			color = mix(color,  vFogColor, getFogFactor(dist)); //white

	}



}



//--
//-- Copyright (C) 2020  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

