
--
-- Copyright (C) 2020  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with gl;  use gl;
with ada.finalization;
with unchecked_deallocation;


generic nsides, nradials : integer;

package spherex is  --Unit Sphere with NO texture & NO normals

type eloid is tagged private;

procedure yseteli( eli: eloid ); --equirect +Y=Npole

procedure draw( eli: eloid; vertbuff, elembuff : gluint );

private


nfaces: constant integer := nsides*nradials; --
nvert : constant integer := nfaces*4*3; --
nelm  : constant integer := nfaces*2*3; --

type varray is array(1..nvert) of float;
type vap is access varray;


type earray is array(1..nelm) of glushort;
type eap is access earray;

type eloid is new ada.finalization.controlled with record
	vert : vap;
	elem : eap;
end record;


procedure initialize(eli: in out eloid);
procedure finalize(eli: in out eloid);

end spherex;

