/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.wsp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.wsp.CurrentDepth;
import jp.sourceforge.stigmata.birthmarks.wsp.Opcode;
import jp.sourceforge.stigmata.birthmarks.wsp.OpcodeManager;

public class StackPatternBasedBirthmarkElement
extends BirthmarkElement
implements Iterable<CurrentDepth> {
    private static final long serialVersionUID = 7965456413167854L;
    private List<CurrentDepth> list = new ArrayList<CurrentDepth>();
    private int weight = -1;

    public StackPatternBasedBirthmarkElement(CurrentDepth[] depthArray) {
        super(StackPatternBasedBirthmarkElement.getStringRepresentation(depthArray));
        for (CurrentDepth depth : depthArray) {
            this.list.add(depth);
        }
    }

    public StackPatternBasedBirthmarkElement(String value) {
        super(value);
        String[] depthList = value.split(", ");
        for (int i = 0; i < depthList.length; ++i) {
            String[] depthStringArray = depthList[i].split(":");
            if (depthStringArray.length != 4) continue;
            int opcode = Integer.parseInt(depthStringArray[0]);
            int depth = Integer.parseInt(depthStringArray[1]);
            int weight = Integer.parseInt(depthStringArray[2]);
            int act = Integer.parseInt(depthStringArray[3]);
            Opcode o = new Opcode(OpcodeManager.getInstance().getOpcode(opcode));
            o.setWeight(weight);
            if (o.getCategory() == Opcode.Category.OBJECT || o.getCategory() == Opcode.Category.INVOKE) {
                o.setAct(act);
            }
            this.list.add(new CurrentDepth(depth, o));
        }
    }

    public int getLength() {
        return this.list.size();
    }

    public CurrentDepth getDepth(int index) {
        return this.list.get(index);
    }

    @Override
    public Iterator<CurrentDepth> iterator() {
        return Collections.unmodifiableList(this.list).iterator();
    }

    public int getWeight(StackPatternBasedBirthmarkElement element) {
        int[][] matrix = new int[element.getLength() + 1][this.getLength() + 1];
        for (int i = 0; i <= element.getLength(); ++i) {
            for (int j = 0; j <= this.getLength(); ++j) {
                matrix[i][j] = i == 0 || j == 0 ? 0 : (element.getDepth(i - 1).getOpcode().getOpcode() == this.getDepth(j - 1).getOpcode().getOpcode() ? matrix[i - 1][j - 1] + this.getDepth(j - 1).getOpcode().getWeight() : Math.max(matrix[i - 1][j], matrix[i][j - 1]));
            }
        }
        int max = 0;
        int last = element.getLength();
        for (int i = 0; i < matrix[last].length; ++i) {
            if (matrix[last][i] <= max) continue;
            max = matrix[last][i];
        }
        return max;
    }

    public int getWeight() {
        if (this.weight < 0) {
            int w = 0;
            for (CurrentDepth depth : this) {
                w += depth.getOpcode().getWeight();
            }
            this.weight = w;
        }
        return this.weight;
    }

    private static String getStringRepresentation(CurrentDepth[] depth) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < depth.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(depth[i]);
        }
        return new String(builder);
    }
}

