/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.wsp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.Label;

public class Opcode
implements Serializable {
    private static final long serialVersionUID = -2349834745416345564L;
    private int opcode;
    private String name;
    private int argumentCount;
    private int act;
    private int weight;
    private Category category;
    private List<Label> labels = new ArrayList<Label>();

    public Opcode(Opcode opcode) {
        this(opcode.getOpcode(), opcode.getName(), opcode.getArgumentCount(), opcode.getAct(), opcode.getCategory());
    }

    public Opcode(int opcode, String name, int argumentCount, int act, String category) {
        this(opcode, name, argumentCount, act, Category.valueOf(category));
    }

    public Opcode(int opcode, String name, int argumentCount, int act, Category category) {
        this.opcode = opcode;
        this.name = name;
        this.argumentCount = argumentCount;
        this.act = act;
        this.category = category;
    }

    Opcode(int opcode, String name, int argumentCount, int act, Category category, int weight) {
        this(opcode, name, argumentCount, act, category);
        this.setWeight(weight);
    }

    public int getOpcode() {
        return this.opcode;
    }

    public String getName() {
        return this.name;
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public void addLabel(Label label) {
        if (label == null) {
            throw new NullPointerException();
        }
        if (this.category != Category.BRANCH) {
            throw new IllegalStateException("this method allows only branch category");
        }
        this.labels.add(label);
    }

    public void setLabels(Label[] labelArray) {
        if (labelArray == null) {
            throw new NullPointerException();
        }
        if (this.category != Category.BRANCH) {
            throw new IllegalStateException("this method allows only branch category");
        }
        this.labels.clear();
        for (Label label : labelArray) {
            if (label == null) {
                throw new NullPointerException();
            }
            this.labels.add(label);
        }
    }

    public Label getLabel(int index) {
        return this.labels.get(index);
    }

    public Iterator<Label> labels() {
        return Collections.unmodifiableList(this.labels).iterator();
    }

    public void setAct(int act) {
        if (this.category != Category.OBJECT && this.category != Category.INVOKE) {
            throw new IllegalStateException("setAct can be called only object and invoke category.");
        }
        this.act = act;
    }

    public int getAct() {
        return this.act;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return String.format("%d:%s:%d:%f(%s)", new Object[]{this.getOpcode(), this.getName(), this.getAct(), this.getWeight(), this.getCategory()});
    }

    public static enum Category {
        NORMAL,
        BRANCH,
        OBJECT,
        INVOKE,
        TARGETER;

    }
}

