package jp.sourceforge.stigmata.birthmarks.extractors;

/*
 * $Id: FrequencyUsedClassesBirthmarkExtractorService.java 294 2008-07-11 08:51:37Z tama3 $
 */

import jp.sourceforge.stigmata.BirthmarkExtractor;
import jp.sourceforge.stigmata.birthmarks.fuc.FrequencyUsedClassesBirthmarkExtractor;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

/**
 * Birthmark Service Provider Interface.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 294 $ 
 */
public class FrequencyUsedClassesBirthmarkExtractorService extends AbstractBirthmarkExtractorService{

    /**
     * returns a type of the birthmark this service provides.
     */
    public String getType(){
        return "fuc";
    }

    public String getExtractorClassName(){
        return FrequencyUsedClassesBirthmarkExtractor.class.getName();
    }

    /**
     * returns a extractor for the birthmark of this service.
     */
    public BirthmarkExtractor getExtractor(BirthmarkSpi service){
        return new FrequencyUsedClassesBirthmarkExtractor(service);
    }
}