package jp.sourceforge.stigmata.birthmarks;

/*
 * $Id: BirthmarkExtractVisitor.java 328 2008-12-01 05:30:43Z tama3 $
 */

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.BirthmarkEnvironment;

import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;

/**
 * Abstract visitor class of extracting birthmarks from class file.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 328 $ 
 */
public abstract class BirthmarkExtractVisitor extends ClassAdapter{
    private Birthmark birthmark;
    private BirthmarkContext context;
    private List<Throwable> causes = new ArrayList<Throwable>();

    public BirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkContext context){
        super(visitor);
        this.birthmark = birthmark;
        this.context = context;
    }

    protected BirthmarkEnvironment getEnvironment(){
        return context.getEnvironment();
    }

    protected BirthmarkContext getContext(){
        return context;
    }

    protected void addElement(BirthmarkElement element){
        birthmark.addElement(element);
    }

    public Birthmark getBirthmark(){
        return birthmark;
    }

    public synchronized void addFailur(Throwable e){
        causes.add(e);
    }

    public boolean isSuccess(){
       return causes.size() == 0;
    }

    public synchronized Throwable[] getCauses(){
       return causes.toArray(new Throwable[causes.size()]);
    }
}
