/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.AvailableOptions;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLineDefinitions;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RStack;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.UJAXP;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CommandLine
implements Serializable,
Cloneable {
    private String name_;
    private CommandLineDefinitions commandLineDefinitions_;
    private AvailableOptions availableOptions_;

    public CommandLine() {
        this.name_ = "";
    }

    public CommandLine(CommandLine source) {
        this.setup(source);
    }

    public CommandLine(RStack stack) {
        this.setup(stack);
    }

    public CommandLine(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public CommandLine(Element element) {
        this.setup(element);
    }

    public CommandLine(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public CommandLine(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public CommandLine(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public CommandLine(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public CommandLine(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public CommandLine(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(CommandLine source) {
        this.name_ = source.name_;
        if (source.commandLineDefinitions_ != null) {
            this.setCommandLineDefinitions((CommandLineDefinitions)source.getCommandLineDefinitions().clone());
        }
        if (source.availableOptions_ != null) {
            this.setAvailableOptions((AvailableOptions)source.getAvailableOptions().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        try {
            this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (CommandLineDefinitions.isMatch(stack)) {
            this.setCommandLineDefinitions(new CommandLineDefinitions(stack));
        }
        if (AvailableOptions.isMatch(stack)) {
            this.setAvailableOptions(new AvailableOptions(stack));
        }
    }

    public Object clone() {
        return new CommandLine(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("command-line");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.commandLineDefinitions_ != null) {
            this.commandLineDefinitions_.makeElement(element);
        }
        if (this.availableOptions_ != null) {
            this.availableOptions_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public CommandLineDefinitions getCommandLineDefinitions() {
        return this.commandLineDefinitions_;
    }

    public void setCommandLineDefinitions(CommandLineDefinitions commandLineDefinitions) {
        this.commandLineDefinitions_ = commandLineDefinitions;
    }

    public AvailableOptions getAvailableOptions() {
        return this.availableOptions_;
    }

    public void setAvailableOptions(AvailableOptions availableOptions) {
        this.availableOptions_ = availableOptions;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<command-line");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.commandLineDefinitions_ != null) {
            this.commandLineDefinitions_.makeTextElement(buffer);
        }
        if (this.availableOptions_ != null) {
            this.availableOptions_.makeTextElement(buffer);
        }
        buffer.append("</command-line>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<command-line");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.commandLineDefinitions_ != null) {
            this.commandLineDefinitions_.makeTextElement(buffer);
        }
        if (this.availableOptions_ != null) {
            this.availableOptions_.makeTextElement(buffer);
        }
        buffer.write("</command-line>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<command-line");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.commandLineDefinitions_ != null) {
            this.commandLineDefinitions_.makeTextElement(buffer);
        }
        if (this.availableOptions_ != null) {
            this.availableOptions_.makeTextElement(buffer);
        }
        buffer.print("</command-line>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "command-line")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return false;
        }
        $match$ = true;
        if (!CommandLineDefinitions.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        if (!AvailableOptions.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return CommandLine.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (CommandLine.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

