/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing.mds;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jp.sourceforge.stigmata.ui.swing.UnsupportedFormatException;
import jp.sourceforge.stigmata.utils.BinaryDataWritable;
import jp.sourceforge.talisman.mds.ui.swing.MdsPane;

public class MdsImageExporter
implements BinaryDataWritable {
    private MdsPane viewer;

    public MdsImageExporter(MdsPane viewer) {
        this.viewer = viewer;
    }

    @Override
    public void writeBinaryData(OutputStream out, String format) throws IOException, UnsupportedFormatException {
        Dimension size = this.viewer.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, size.width, size.height);
        this.viewer.update((Graphics)g);
        try {
            ImageIO.write((RenderedImage)image, format, out);
            out.flush();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)this.viewer), e.getMessage(), this.viewer.getMessages().get("error.dialog.title"), 2);
        }
    }
}

