/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing.filter;

import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jp.sourceforge.stigmata.ComparisonPairFilter;
import jp.sourceforge.stigmata.filter.FilterTarget;
import jp.sourceforge.stigmata.filter.TargetNameComparisonPairFilter;
import jp.sourceforge.stigmata.filter.TargetNameComparisonPairFilterService;
import jp.sourceforge.stigmata.spi.ComparisonPairFilterSpi;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.filter.AbstractComparisonPairFilterComponentService;
import jp.sourceforge.stigmata.ui.swing.filter.ComparisonPairFilterPane;

public class TargetNameComparisonPairFilterComponentService
extends AbstractComparisonPairFilterComponentService {
    @Override
    public ComparisonPairFilterPane createComponent(StigmataFrame frame, ComparisonPairFilterSpi service) {
        return new Pane(frame, service);
    }

    @Override
    public String getFilterName() {
        return "name";
    }

    @Override
    public ComparisonPairFilterSpi getComparisonPairFilterService() {
        return new TargetNameComparisonPairFilterService();
    }

    private static class Pane
    extends ComparisonPairFilterPane {
        private static final long serialVersionUID = 8912037614500713027L;
        private ComparisonPairFilterSpi service;
        private JComboBox criterionType;
        private JTextField value;
        private JComboBox targetType;

        public Pane(StigmataFrame frame, ComparisonPairFilterSpi service) {
            super(frame);
            this.service = service;
            this.initLayouts();
        }

        @Override
        public String[] getErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.value.getText().trim().equals("")) {
                errors.add(this.getMessages().get("error.empty.value"));
            }
            return errors.toArray(new String[errors.size()]);
        }

        @Override
        public ComparisonPairFilter getFilter() {
            try {
                TargetNameComparisonPairFilter filter = new TargetNameComparisonPairFilter(this.service);
                filter.setCriterion(this.getCriterion((String)this.criterionType.getSelectedItem()));
                filter.setValue(this.value.getText());
                filter.setTarget(this.getTarget((String)this.targetType.getSelectedItem()));
                return filter;
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public void resetComponents() {
            this.value.setText("");
            this.criterionType.setSelectedIndex(0);
            this.targetType.setSelectedItem(this.getDisplayTarget(FilterTarget.BOTH_TARGETS));
        }

        @Override
        public void setFilter(ComparisonPairFilter cpf) {
            TargetNameComparisonPairFilter filter = (TargetNameComparisonPairFilter)cpf;
            this.criterionType.setSelectedItem(this.getDisplayCriterion(filter.getCriterion()));
            this.value.setText(filter.getValue());
            this.targetType.setSelectedItem(this.getDisplayTarget(filter.getTarget()));
        }

        private void initLayouts() {
            JLabel label = new JLabel(this.getMessages().get("filter.name.label"));
            this.value = new JTextField();
            this.criterionType = this.createCriteriaBox(TargetNameComparisonPairFilter.getValidCriteria());
            this.targetType = this.createTargetBox();
            this.setLayout(new GridLayout(4, 1));
            this.add(label);
            this.add(this.targetType);
            this.add(this.criterionType);
            this.add(this.value);
        }
    }
}

