/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing.filter;

import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.sourceforge.stigmata.ComparisonPairFilter;
import jp.sourceforge.stigmata.filter.SimilarityComparisonPairFilter;
import jp.sourceforge.stigmata.filter.SimilarityComparisonPairFilterService;
import jp.sourceforge.stigmata.spi.ComparisonPairFilterSpi;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.filter.AbstractComparisonPairFilterComponentService;
import jp.sourceforge.stigmata.ui.swing.filter.ComparisonPairFilterPane;

public class SimilarityComparisonPairFilterComponentService
extends AbstractComparisonPairFilterComponentService {
    @Override
    public ComparisonPairFilterPane createComponent(StigmataFrame frame, ComparisonPairFilterSpi service) {
        return new Pane(frame, service);
    }

    @Override
    public String getFilterName() {
        return "similarity";
    }

    @Override
    public ComparisonPairFilterSpi getComparisonPairFilterService() {
        return new SimilarityComparisonPairFilterService();
    }

    private static class Pane
    extends ComparisonPairFilterPane {
        private static final long serialVersionUID = 8912037614500713027L;
        private ComparisonPairFilterSpi service;
        private JComboBox criterionType;
        private JTextField threshold;

        public Pane(StigmataFrame frame, ComparisonPairFilterSpi service) {
            super(frame);
            this.service = service;
            this.initLayouts();
        }

        @Override
        public String[] getErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.threshold.getText().trim().equals("")) {
                errors.add(this.getMessages().get("error.empty.threshold"));
            }
            try {
                double v = Double.parseDouble(this.threshold.getText());
                if (v < 0.0) {
                    errors.add(this.getMessages().format("error.negative.value", new Object[]{v}));
                } else if (v > 1.0) {
                    errors.add(this.getMessages().format("error.over.range", new Object[]{"0-1"}));
                }
            }
            catch (NumberFormatException e) {
                errors.add(this.getMessages().format("error.invalid.format.double", new Object[]{this.threshold.getText()}));
            }
            return errors.toArray(new String[errors.size()]);
        }

        @Override
        public ComparisonPairFilter getFilter() {
            try {
                SimilarityComparisonPairFilter filter = new SimilarityComparisonPairFilter(this.service);
                filter.setThreshold(Double.parseDouble(this.threshold.getText()));
                filter.setCriterion(this.getCriterion((String)this.criterionType.getSelectedItem()));
                return filter;
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public void resetComponents() {
            this.threshold.setText("");
            this.criterionType.setSelectedIndex(0);
        }

        @Override
        public void setFilter(ComparisonPairFilter filter) {
            if (filter != null) {
                SimilarityComparisonPairFilter sf = (SimilarityComparisonPairFilter)filter;
                this.criterionType.setSelectedItem(this.getDisplayCriterion(sf.getCriterion()));
                this.threshold.setText(Double.toString(sf.getThreshold()));
            } else {
                this.resetComponents();
            }
        }

        private void initLayouts() {
            JLabel label = new JLabel(this.getMessages().get("filter.similarity.label"));
            this.threshold = new JTextField();
            this.criterionType = this.createCriteriaBox(SimilarityComparisonPairFilter.getValidCriteria());
            this.setLayout(new GridLayout(3, 1));
            this.add(label);
            this.add(this.criterionType);
            this.add(this.threshold);
            this.threshold.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                }
            });
        }
    }
}

