/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkElementClassNotFoundException;
import jp.sourceforge.stigmata.BirthmarkEngine;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.BirthmarkExtractionFailedException;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.ComparisonPair;
import jp.sourceforge.stigmata.ComparisonResultSet;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.Main;
import jp.sourceforge.stigmata.Stigmata;
import jp.sourceforge.stigmata.event.BirthmarkEngineAdapter;
import jp.sourceforge.stigmata.event.BirthmarkEngineEvent;
import jp.sourceforge.stigmata.event.WarningMessages;
import jp.sourceforge.stigmata.result.CertainPairComparisonResultSet;
import jp.sourceforge.stigmata.ui.swing.BirthmarkExtractionResultPane;
import jp.sourceforge.stigmata.ui.swing.BirthmarkServiceListener;
import jp.sourceforge.stigmata.ui.swing.ControlPane;
import jp.sourceforge.stigmata.ui.swing.FileIOManager;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.PairComparisonPane;
import jp.sourceforge.stigmata.ui.swing.PairComparisonResultSetPane;
import jp.sourceforge.stigmata.ui.swing.RoundRobinComparisonResultPane;
import jp.sourceforge.stigmata.ui.swing.actions.AboutAction;
import jp.sourceforge.stigmata.ui.swing.actions.LicenseAction;
import jp.sourceforge.stigmata.ui.swing.graph.SimilarityDistributionGraphPane;
import jp.sourceforge.stigmata.ui.swing.mds.MdsViewerPane;
import jp.sourceforge.stigmata.ui.swing.tab.EditableTabbedPane;
import jp.sourceforge.stigmata.utils.Utility;
import jp.sourceforge.talisman.i18n.Messages;
import jp.sourceforge.talisman.i18n.ResourceNotFoundException;
import org.apache.commons.cli.ParseException;

public class StigmataFrame
extends JFrame {
    private static final long serialVersionUID = 92345543665342134L;
    private Messages messages;
    private JTabbedPane tabPane;
    private JMenuItem closeTabMenu;
    private JMenuItem saveMenu;
    private JCheckBoxMenuItem expertmodeMenu;
    private Stigmata stigmata;
    private BirthmarkEnvironment environment;
    private ControlPane control;
    private FileIOManager fileio;
    private Map<String, Integer> countmap = new HashMap<String, Integer>();

    public StigmataFrame() {
        this(Stigmata.getInstance());
    }

    public StigmataFrame(Stigmata stigmata) {
        this(stigmata, BirthmarkEnvironment.getDefaultEnvironment());
    }

    public StigmataFrame(Stigmata stigmata, BirthmarkEnvironment environment) {
        this.stigmata = stigmata;
        this.environment = environment;
        this.fileio = new FileIOManager(this, environment);
        try {
            this.messages = new Messages("resources.messages");
        }
        catch (ResourceNotFoundException e) {
            throw new InternalError(e.getMessage());
        }
        Image iconImage = GUIUtility.getImage(this.getMessages(), "stigmata.icon");
        if (iconImage != null) {
            this.setIconImage(iconImage);
        }
        stigmata.addBirthmarkEngineListener(new BirthmarkEngineAdapter(){

            @Override
            public void operationDone(BirthmarkEngineEvent e) {
                StigmataFrame.this.showWarnings(e.getMessage());
            }
        });
        this.initLayouts();
    }

    public Messages getMessages() {
        return this.messages;
    }

    public boolean isNeedToSaveSettings() {
        return this.saveMenu.isEnabled();
    }

    public void setNeedToSaveSettings(boolean flag) {
        this.saveMenu.setEnabled(flag);
    }

    public Stigmata getStigmata() {
        return this.stigmata;
    }

    public BirthmarkEnvironment getEnvironment() {
        return this.environment;
    }

    public File getCurrentDirectory() {
        return this.fileio.getCurrentDirectory();
    }

    public void setCurrentDirectory(File file) {
        try {
            this.fileio.setCurrentDirectory(file);
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(this, this.getMessages().get("notdirectory.dialog.message", file.getName()), this.getMessages().get("notdirectory.dialog.title"), 0);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public File[] openFiles(FileFilter[] filters, boolean multipleSelectable, boolean directorySelectable) {
        return this.fileio.openFiles(filters, multipleSelectable, directorySelectable);
    }

    public File getOpenFile(String[] exts, String desc) {
        return this.fileio.findFile(true, exts, desc);
    }

    public File getSaveFile(String[] exts, String desc) {
        return this.fileio.findFile(false, exts, desc);
    }

    public void addBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.control.addBirthmarkServiceListener(listener);
    }

    public void removeBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.control.removeBirthmarkServiceListener(listener);
    }

    public void compareDetails(BirthmarkSet target1, BirthmarkSet target2, BirthmarkContext context) {
        PairComparisonPane detail = new PairComparisonPane(this, new ComparisonPair(target1, target2, context));
        int compareDetail = this.getNextCount("compare_detail");
        GUIUtility.addNewTab(this.getMessages(), "comparedetail", this.tabPane, detail, new Object[]{new Integer(compareDetail)}, new Object[]{Utility.array2String(target1.getBirthmarkTypes()), target1.getName(), target2.getName()}, true);
    }

    public void compareRoundRobin(String[] targetX, String[] targetY, BirthmarkContext context) {
        try {
            BirthmarkEngine engine = this.getStigmata().createEngine(context.getEnvironment());
            ExtractionResultSet ers = engine.extract(targetX, targetY, context);
            RoundRobinComparisonResultPane compare = new RoundRobinComparisonResultPane(this, ers);
            int compareCount = this.getNextCount("compare");
            GUIUtility.addNewTab(this.getMessages(), "compare", this.tabPane, compare, new Object[]{new Integer(compareCount)}, new Object[]{Utility.array2String(context.getBirthmarkTypes()), Utility.array2String(targetX), Utility.array2String(targetY)}, true);
        }
        catch (Throwable e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareRoundRobinFilter(String[] targetX, String[] targetY, BirthmarkContext context) {
        try {
            BirthmarkEngine engine = this.getStigmata().createEngine(context.getEnvironment());
            ExtractionResultSet ers = engine.extract(targetX, targetY, context);
            ComparisonResultSet resultset = engine.compare(ers);
            if (context.hasFilter()) {
                resultset = engine.filter(resultset);
            }
            int compareCount = this.getNextCount("compare");
            GUIUtility.addNewTab(this.getMessages(), "compare", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(compareCount)}, new Object[]{Utility.array2String(context.getBirthmarkTypes()), Utility.array2String(targetX), Utility.array2String(targetY)}, true);
        }
        catch (Throwable e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareGuessedPair(String[] targetX, String[] targetY, BirthmarkContext context) {
        try {
            BirthmarkEngine engine = this.getStigmata().createEngine(context.getEnvironment());
            ExtractionResultSet extraction = engine.extract(targetX, targetY, context);
            int comparePair = this.getNextCount("compare_pair");
            CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(extraction);
            GUIUtility.addNewTab(this.getMessages(), "comparepair", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(comparePair)}, new Object[]{Utility.array2String(context.getBirthmarkTypes()), Utility.array2String(targetX), Utility.array2String(targetY)}, true);
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Throwable e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareSpecifiedPair(String[] targetX, String[] targetY, BirthmarkContext context) {
        File file = this.getOpenFile(this.getMessages().getArray("comparemapping.extension"), this.getMessages().get("comparemapping.description"));
        if (file != null) {
            Map<String, String> mapping = this.constructMapping(file);
            try {
                BirthmarkEngine engine = this.getStigmata().createEngine(context.getEnvironment());
                context.setNameMappings(mapping);
                ComparisonResultSet crs = engine.compare(targetX, targetY, context);
                int comparePair = this.getNextCount("compare_pair");
                GUIUtility.addNewTab(this.getMessages(), "comparepair", this.tabPane, new PairComparisonResultSetPane(this, crs), new Object[]{new Integer(comparePair)}, new Object[]{Utility.array2String(context.getBirthmarkTypes()), Utility.array2String(targetX), Utility.array2String(targetY)}, true);
            }
            catch (Exception e) {
                this.showExceptionMessage(e);
            }
        }
    }

    public void showComparisonResultSet(ComparisonResultSet resultset) {
        int comparePair = this.getNextCount("compare_pair");
        GUIUtility.addNewTab(this.getMessages(), "comparisonresultset", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(comparePair)}, null, true);
    }

    public void showMdsGraph(BirthmarkSet[] set, BirthmarkContext context) {
        try {
            MdsViewerPane panel = new MdsViewerPane(this, set, context);
            int mappingGraphCount = this.getNextCount("mds_graph");
            GUIUtility.addNewTab(this.getMessages(), "mappinggraph", this.tabPane, panel, new Object[]{new Integer(mappingGraphCount)}, null, true);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void showSimilarityDistributionGraph(Map<Integer, Integer> distributions) {
        SimilarityDistributionGraphPane graph = new SimilarityDistributionGraphPane(this, distributions);
        int similarityGraphCount = this.getNextCount("similarity_graph");
        GUIUtility.addNewTab(this.getMessages(), "similaritygraph", this.tabPane, graph, new Object[]{new Integer(similarityGraphCount)}, null, true);
    }

    public void compareExtractionResult(ExtractionResultSet ers) {
        RoundRobinComparisonResultPane compare = new RoundRobinComparisonResultPane(this, ers);
        int compareCount = this.getNextCount("compare");
        GUIUtility.addNewTab(this.getMessages(), "compare", this.tabPane, compare, new Object[]{new Integer(compareCount)}, new Object[]{Utility.array2String(ers.getBirthmarkTypes()), Utility.array2String(new String[0]), Utility.array2String(new String[0])}, true);
    }

    public void showExtractionResult(ExtractionResultSet ers) {
        int extractCount = this.getNextCount("extract");
        BirthmarkExtractionResultPane viewer = new BirthmarkExtractionResultPane(this, ers);
        GUIUtility.addNewTab(this.getMessages(), "extract", this.tabPane, viewer, new Object[]{new Integer(extractCount)}, new Object[]{Utility.array2String(ers.getBirthmarkTypes())}, true);
    }

    public void extract(String[] targetX, String[] targetY, BirthmarkContext context) {
        try {
            BirthmarkEngine engine = this.getStigmata().createEngine(context.getEnvironment());
            ExtractionResultSet ers = engine.extract(targetX, targetY, context);
            this.showExtractionResult(ers);
        }
        catch (Throwable e) {
            this.showExceptionMessage(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> constructMapping(File file) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split(", *");
                if (tokens.length < 2) continue;
                mapping.put(tokens[0], tokens[1]);
            }
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return mapping;
    }

    private void reloadSettings(String[] args) {
        try {
            this.setVisible(false);
            this.dispose();
            new Main(args);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void clearSettings() {
        Utility.deleteDirectory(new File(BirthmarkEnvironment.getStigmataHome()));
        this.reloadSettings(new String[]{"--reset-config", "--mode", "gui"});
    }

    private void initLayouts() {
        this.setTitle(this.getMessages().get("stigmata.frame.title"));
        this.initComponents();
        this.control = new ControlPane(this);
        GUIUtility.addNewTab(this.getMessages(), "control", this.tabPane, this.control, null, null, false);
        this.control.inititalize();
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        this.setNeedToSaveSettings(false);
        this.setSize(900, 600);
    }

    private void showWarnings(WarningMessages warnings) {
        if (warnings.getWarningCount() > 0) {
            StringBuilder sb = new StringBuilder("<html><body><dl>");
            Iterator<Exception> i = warnings.exceptions();
            while (i.hasNext()) {
                Exception e = i.next();
                sb.append("<dt>").append(e.getClass().getName()).append("</dt>");
                sb.append("<dd>").append(e.getMessage()).append("</dd>");
                sb.append("<dd>").append(warnings.getString(e)).append("</dd>");
            }
            sb.append("</dl></body></html>");
            JOptionPane.showMessageDialog(this, new String(sb), this.getMessages().get("warning.dialog.title"), 2);
        }
    }

    private void initComponents() {
        this.setDefaultUI();
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.createHelpMenu());
        this.setJMenuBar(menubar);
        this.tabPane = new EditableTabbedPane(this);
        this.add((Component)this.tabPane, "Center");
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                String title = StigmataFrame.this.tabPane.getTitleAt(StigmataFrame.this.tabPane.getSelectedIndex());
                StigmataFrame.this.closeTabMenu.setEnabled(!title.equals(StigmataFrame.this.getMessages().get("control.tab.label")));
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                boolean closeFlag = true;
                if (StigmataFrame.this.isNeedToSaveSettings()) {
                    int returnValue = JOptionPane.showConfirmDialog(StigmataFrame.this, StigmataFrame.this.getMessages().get("needtosave.settings.message"), StigmataFrame.this.getMessages().get("needtosave.settings.title"), 1, 2);
                    boolean bl = closeFlag = returnValue != 2;
                    if (returnValue == 0) {
                        StigmataFrame.this.control.saveSettings(new File(BirthmarkEnvironment.getStigmataHome(), "stigmata.xml"));
                    }
                }
                if (closeFlag) {
                    StigmataFrame.this.setVisible(false);
                    StigmataFrame.this.dispose();
                }
            }
        });
        this.setDefaultCloseOperation(0);
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = GUIUtility.createJMenu(this.getMessages(), "fileMenu");
        JMenuItem newFrameMenu = GUIUtility.createJMenuItem(this.getMessages(), "newframe");
        JMenuItem saveMenu = GUIUtility.createJMenuItem(this.getMessages(), "savesetting");
        JMenuItem exportMenu = GUIUtility.createJMenuItem(this.getMessages(), "exportsetting");
        JMenuItem clearMenu = GUIUtility.createJMenuItem(this.getMessages(), "clearsetting");
        JMenuItem refreshMenu = GUIUtility.createJMenuItem(this.getMessages(), "refreshsetting");
        JMenuItem closeTabMenu = GUIUtility.createJMenuItem(this.getMessages(), "closetab");
        JMenuItem closeMenu = GUIUtility.createJMenuItem(this.getMessages(), "closeframe");
        JMenuItem exitMenu = GUIUtility.createJMenuItem(this.getMessages(), "exit");
        this.closeTabMenu = closeTabMenu;
        this.saveMenu = saveMenu;
        saveMenu.setEnabled(false);
        fileMenu.add(newFrameMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(saveMenu);
        fileMenu.add(exportMenu);
        fileMenu.add(refreshMenu);
        fileMenu.add(clearMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(closeTabMenu);
        fileMenu.add(closeMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(exitMenu);
        newFrameMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StigmataFrame frame = new StigmataFrame(StigmataFrame.this.stigmata, StigmataFrame.this.environment);
                frame.setVisible(true);
            }
        });
        saveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.control.saveSettings(new File(BirthmarkEnvironment.getStigmataHome(), "stigmata.xml"));
                StigmataFrame.this.setNeedToSaveSettings(false);
            }
        });
        exportMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.control.exportSettings();
            }
        });
        closeTabMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.closeTabMenuActionPerformed();
            }
        });
        clearMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.clearSettings();
            }
        });
        refreshMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.reloadSettings(new String[]{"--mode", "gui"});
            }
        });
        closeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.setVisible(false);
                StigmataFrame.this.dispose();
            }
        });
        exitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        return fileMenu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = GUIUtility.createJMenu(this.getMessages(), "helpmenu");
        JMenuItem about = GUIUtility.createJMenuItem(this.getMessages(), "about", new AboutAction(this));
        JMenuItem license = GUIUtility.createJMenuItem(this.getMessages(), "license", new LicenseAction(this));
        JMenuItem help = GUIUtility.createJMenuItem(this.getMessages(), "helpmenu");
        this.expertmodeMenu = GUIUtility.createJCheckBoxMenuItem(this.getMessages(), "expertmenu");
        menu.add(about);
        menu.add(license);
        menu.add(help);
        menu.add(new JSeparator());
        menu.add(this.createLookAndFeelMenu());
        menu.add(new JSeparator());
        menu.add(this.expertmodeMenu);
        this.expertmodeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.expertMenuActionPerformed(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        });
        help.setEnabled(false);
        return menu;
    }

    private JMenu createLookAndFeelMenu() {
        JMenu laf = GUIUtility.createJMenu(this.getMessages(), "lookandfeel");
        ButtonGroup bg = new ButtonGroup();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        LookAndFeel lookfeel = UIManager.getLookAndFeel();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String command = e.getActionCommand();
                    UIManager.setLookAndFeel(command);
                    SwingUtilities.updateComponentTreeUI(StigmataFrame.this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        for (int i = 0; i < info.length; ++i) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(info[i].getName());
            item.setActionCommand(info[i].getClassName());
            item.addActionListener(listener);
            bg.add(item);
            laf.add(item);
            if (!info[i].getClassName().equals(lookfeel.getClass().getName())) continue;
            item.setState(true);
        }
        return laf;
    }

    public void setExpertMode(boolean expertmode) {
        this.expertmodeMenu.setState(expertmode);
    }

    private void expertMenuActionPerformed(boolean status) {
        this.control.setExpertMode(status);
    }

    private void showExceptionMessage(Throwable e) {
        if (e instanceof BirthmarkElementClassNotFoundException) {
            this.showClassNotFoundMessage((BirthmarkElementClassNotFoundException)e);
        } else if (e instanceof OutOfMemoryError) {
            this.showOutOfMemoryError();
        } else {
            JTextArea area = new JTextArea(20, 60);
            StringWriter writer = new StringWriter();
            PrintWriter out = new PrintWriter(writer);
            e.printStackTrace(out);
            if (e instanceof BirthmarkExtractionFailedException) {
                out.println("Causes:");
                for (Throwable t : ((BirthmarkExtractionFailedException)e).getCauses()) {
                    t.printStackTrace(out);
                }
            }
            out.close();
            area.setText(writer.toString());
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JLabel("<html><body><p>" + this.getMessages().get("error.message.contactus") + "</p></body></html>"), "North");
            panel.add((Component)new JScrollPane(area), "Center");
            JOptionPane.showMessageDialog(this, panel, this.getMessages().get("error.dialog.title"), 2);
        }
    }

    private void showOutOfMemoryError() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body><p>");
        sb.append(this.getMessages().get("error.message.outofmemory"));
        sb.append("</p></body></html>");
        JOptionPane.showMessageDialog(this, new String(sb), this.getMessages().get("error.dialog.title"), 2);
    }

    private void showClassNotFoundMessage(BirthmarkElementClassNotFoundException e) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body><p>");
        sb.append(this.getMessages().get("error.message.classpath"));
        sb.append("</p><ul>");
        for (String name : e.getClassNames()) {
            sb.append("<li>").append(name).append("</li>");
        }
        sb.append("</ul></body></html>");
        JOptionPane.showMessageDialog(this, new String(sb), this.getMessages().get("error.dialog.title"), 2);
    }

    private void closeTabMenuActionPerformed() {
        int index = this.tabPane.getSelectedIndex();
        if (index == 0) {
            JOptionPane.showMessageDialog(this, this.getMessages().get("cannotclosecontroltab.dialog.message"), this.getMessages().get("cannotclosecontroltab.dialog.title"), 0);
        } else {
            this.tabPane.removeTabAt(index);
        }
    }

    private int getNextCount(String label) {
        Integer i = this.countmap.get(label);
        if (i == null) {
            i = new Integer(0);
        }
        i = i + 1;
        this.countmap.put(label, i);
        return i;
    }

    private void setDefaultUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

