/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sourceforge.stigmata.ComparisonPairFilter;
import jp.sourceforge.stigmata.ComparisonPairFilterSet;
import jp.sourceforge.stigmata.filter.ComparisonPairFilterManager;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.filter.ComparisonPairFilterRetainable;
import jp.sourceforge.stigmata.ui.swing.filter.FilterEditingPane;
import jp.sourceforge.stigmata.ui.swing.filter.FilterSetDefinitionPane;

public class FilterManagementPane
extends JPanel
implements ComparisonPairFilterRetainable {
    private static final long serialVersionUID = 972135792354L;
    private StigmataFrame stigmata;
    private FilterSetDefinitionPane definition;
    private FilterEditingPane filterPane;
    private JList list;
    private DefaultListModel model;
    private Map<String, ComparisonPairFilterSet> filters = new HashMap<String, ComparisonPairFilterSet>();

    public FilterManagementPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initLayouts();
    }

    public void reset() {
        this.definition.reset();
        this.filterPane.reset();
        this.model.removeAllElements();
        ComparisonPairFilterManager manager = this.stigmata.getEnvironment().getFilterManager();
        for (ComparisonPairFilterSet filterset : manager.getFilterSets()) {
            this.addFilterSet(filterset);
        }
    }

    public void updateFilterManager(ComparisonPairFilterManager manager) {
        for (ComparisonPairFilterSet filterset : this.filters.values()) {
            manager.addFilterSet(filterset);
        }
    }

    @Override
    public void addFilterSet(ComparisonPairFilterSet filterset) {
        this.filters.put(filterset.getName(), filterset);
        this.model.addElement(filterset.getName());
        this.list.setSelectedIndex(this.model.getSize() - 1);
    }

    @Override
    public void removeFilterSet(String name) {
        this.filters.remove(name);
        this.model.removeElement(name);
        this.list.clearSelection();
    }

    @Override
    public void updateFilterSet(String oldName, ComparisonPairFilterSet newfilter) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            if (!oldName.equals(this.model.getElementAt(i))) continue;
            this.model.setElementAt(newfilter.getName(), i);
            break;
        }
        this.filters.remove(oldName);
        this.filters.put(newfilter.getName(), newfilter);
    }

    @Override
    public ComparisonPairFilterSet getFilterSet(String name) {
        return this.filters.get(name);
    }

    @Override
    public void filterSelected(ComparisonPairFilter filter) {
        this.filterPane.setFilter(filter);
    }

    private void initLayouts() {
        this.definition = new FilterSetDefinitionPane(this.stigmata, this);
        this.filterPane = new FilterEditingPane(this.stigmata);
        this.filterPane.addComparisonPairFilterListener(this.definition);
        JComponent filtersetlist = this.createFilterSetPane();
        GUIUtility.decorateJComponent(this.stigmata.getMessages(), filtersetlist, "filtersetlist.pane");
        GUIUtility.decorateJComponent(this.stigmata.getMessages(), this.definition, "filterdefinition.pane");
        GUIUtility.decorateJComponent(this.stigmata.getMessages(), this.filterPane, "filter.pane");
        this.setLayout(new GridLayout(1, 3));
        this.add(filtersetlist);
        this.add(this.definition);
        this.add(this.filterPane);
    }

    private JComponent createFilterSetPane() {
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        final JButton upButton = GUIUtility.createButton(this.stigmata.getMessages(), "moveup");
        final JButton downButton = GUIUtility.createButton(this.stigmata.getMessages(), "movedown");
        Box south = Box.createHorizontalBox();
        south.add(Box.createHorizontalGlue());
        south.add(upButton);
        south.add(Box.createHorizontalGlue());
        south.add(downButton);
        south.add(Box.createHorizontalGlue());
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = FilterManagementPane.this.list.locationToIndex(e.getPoint());
                FilterManagementPane.this.list.setSelectedIndex(index);
                FilterManagementPane.this.updateUI();
            }
        });
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] indexes = FilterManagementPane.this.list.getSelectedIndices();
                int rows = FilterManagementPane.this.model.getSize();
                upButton.setEnabled(indexes.length == 1 && rows > 1 && indexes[0] != 0);
                downButton.setEnabled(indexes.length == 1 && rows > 1 && indexes[0] != rows - 1);
                if (indexes.length != 1) {
                    FilterManagementPane.this.definition.setFilterSet(null);
                } else {
                    FilterManagementPane.this.definition.setFilterSet((ComparisonPairFilterSet)FilterManagementPane.this.filters.get(FilterManagementPane.this.model.getElementAt(indexes[0])));
                }
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int step = 1;
                if (e.getActionCommand().equals("moveup")) {
                    step = -1;
                }
                int index = FilterManagementPane.this.list.getSelectedIndex();
                Object e1 = FilterManagementPane.this.model.getElementAt(index);
                Object e2 = FilterManagementPane.this.model.getElementAt(index + step);
                FilterManagementPane.this.model.setElementAt(e1, index + step);
                FilterManagementPane.this.model.setElementAt(e2, index);
                FilterManagementPane.this.list.setSelectedIndex(index + step);
            }
        };
        upButton.addActionListener(listener);
        downButton.addActionListener(listener);
        upButton.setEnabled(false);
        downButton.setEnabled(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.list), "Center");
        panel.add((Component)south, "South");
        return panel;
    }
}

