/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.result.history.ExtractedBirthmarkHistory;
import jp.sourceforge.stigmata.result.history.ExtractedBirthmarkServiceManager;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.actions.PopupShowAction;
import jp.sourceforge.talisman.i18n.Messages;

public class ExtractedHistoryPane
extends JPanel {
    private static final long serialVersionUID = 4070750464486981964L;
    private StigmataFrame stigmata;
    private JComboBox combo;
    private JList list;
    private DefaultListModel model;
    private ExtractedBirthmarkServiceManager historyManager;
    private ExtractedBirthmarkHistory currentHistory;

    public ExtractedHistoryPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initLayouts();
        this.initData();
    }

    private void updateList() {
        String historyId = (String)this.combo.getSelectedItem();
        this.currentHistory = this.historyManager.getHistory(historyId);
        this.model.clear();
        for (String id : this.currentHistory) {
            this.model.addElement(id);
        }
    }

    private void initData() {
        this.historyManager = new ExtractedBirthmarkServiceManager(this.stigmata.getEnvironment());
        for (String id : this.historyManager.getHistoryIds()) {
            this.combo.addItem(id);
        }
    }

    private void showAction(String id) {
        ExtractionResultSet ers = this.currentHistory.getResultSet(id);
        this.stigmata.showExtractionResult(ers);
    }

    private void initLayouts() {
        Messages messages = this.stigmata.getMessages();
        this.setLayout(new BorderLayout());
        final AbstractAction showAction = new AbstractAction(){
            private static final long serialVersionUID = 2156350514762218963L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractedHistoryPane.this.showAction((String)ExtractedHistoryPane.this.model.get(ExtractedHistoryPane.this.list.getSelectedIndex()));
            }
        };
        AbstractAction refreshAction = new AbstractAction(){
            private static final long serialVersionUID = 214765021455345371L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractedHistoryPane.this.updateList();
            }
        };
        final AbstractAction deleteAction = new AbstractAction(){
            private static final long serialVersionUID = 8145188292702648924L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indeces = ExtractedHistoryPane.this.list.getSelectedIndices();
                for (int i = indeces.length - 1; i >= 0; --i) {
                    String id = (String)ExtractedHistoryPane.this.model.get(indeces[i]);
                    ExtractedHistoryPane.this.currentHistory.deleteResultSet(id);
                    ExtractedHistoryPane.this.model.remove(indeces[i]);
                }
                ExtractedHistoryPane.this.list.clearSelection();
            }
        };
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.combo = new JComboBox();
        this.list.setSelectionMode(2);
        GUIUtility.decorateJComponent(messages, this.list, "historylist");
        GUIUtility.decorateJComponent(messages, this.combo, "historylocation");
        JButton showButton = GUIUtility.createButton(messages, "showhistory", showAction);
        JButton refreshButton = GUIUtility.createButton(messages, "refreshhistory", refreshAction);
        JButton deleteButton = GUIUtility.createButton(messages, "deletehistory", deleteAction);
        deleteAction.setEnabled(false);
        showAction.setEnabled(false);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] indeces = ExtractedHistoryPane.this.list.getSelectedIndices();
                showAction.setEnabled(ExtractedHistoryPane.this.currentHistory != null && indeces.length == 1);
                deleteAction.setEnabled(ExtractedHistoryPane.this.currentHistory != null && indeces.length > 0);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = ExtractedHistoryPane.this.list.locationToIndex(e.getPoint());
                if (index >= 0 && e.getClickCount() == 2) {
                    ExtractedHistoryPane.this.showAction((String)ExtractedHistoryPane.this.model.get(index));
                }
            }
        });
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractedHistoryPane.this.updateList();
            }
        });
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.list);
        Box south = Box.createHorizontalBox();
        south.add(Box.createHorizontalGlue());
        south.add(showButton);
        south.add(Box.createHorizontalGlue());
        south.add(refreshButton);
        south.add(Box.createHorizontalGlue());
        south.add(deleteButton);
        south.add(Box.createHorizontalGlue());
        this.add((Component)this.combo, "North");
        this.add((Component)scroll, "Center");
        this.add((Component)south, "South");
        JPopupMenu popup = new JPopupMenu();
        popup.add((Component)GUIUtility.createJMenuItem(messages, "showhistory"), showAction);
        popup.add((Component)GUIUtility.createJMenuItem(messages, "refreshhistory"), refreshAction);
        popup.add((Component)GUIUtility.createJMenuItem(messages, "deletehistory"), deleteAction);
        this.list.addMouseListener(new PopupShowAction(popup));
    }
}

