/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;
import jp.sourceforge.stigmata.ui.swing.BirthmarkSelectablePane;
import jp.sourceforge.stigmata.ui.swing.BirthmarkSelection;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;

public class BirthmarkSelectionListPane
extends BirthmarkSelectablePane {
    private static final long serialVersionUID = 3209854654743223453L;
    private DefaultListModel model;
    private JList list;

    public BirthmarkSelectionListPane(StigmataFrame stigmata) {
        super(stigmata);
        this.initLayouts();
    }

    @Override
    public void serviceRemoved(BirthmarkSpi service) {
        BirthmarkSelection elem = this.getSelection(service.getType());
        this.model.removeElement(elem);
        super.serviceRemoved(service);
    }

    private void initLayouts() {
        this.setLayout(new BorderLayout());
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        JScrollPane scroll = new JScrollPane(this.list);
        this.add((Component)scroll, "Center");
        this.list.setCellRenderer(new Renderer());
        this.list.setVisibleRowCount(5);
        JButton checkAll = GUIUtility.createButton(this.getMessages(), "checkall");
        JButton uncheckAll = GUIUtility.createButton(this.getMessages(), "uncheckall");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(checkAll);
        box.add(Box.createHorizontalGlue());
        box.add(uncheckAll);
        box.add(Box.createHorizontalGlue());
        this.add((Component)box, "South");
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean flag = e.getActionCommand().equals("checkall");
                Iterator<BirthmarkSelection> i = BirthmarkSelectionListPane.this.birthmarkSelections();
                while (i.hasNext()) {
                    BirthmarkSelection le = i.next();
                    le.setSelected(flag);
                    BirthmarkSelectionListPane.this.fireEvent();
                }
                BirthmarkSelectionListPane.this.updateUI();
            }
        };
        checkAll.addActionListener(listener);
        uncheckAll.addActionListener(listener);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = BirthmarkSelectionListPane.this.list.locationToIndex(e.getPoint());
                BirthmarkSelectionListPane.this.list.setSelectedIndex(index);
                BirthmarkSelection elem = (BirthmarkSelection)BirthmarkSelectionListPane.this.model.getElementAt(index);
                elem.setSelected(!elem.isSelected());
                BirthmarkSelectionListPane.this.updateUI();
            }
        });
    }

    @Override
    protected void updateLayouts() {
        this.model.removeAllElements();
        Iterator<BirthmarkSelection> i = this.birthmarkSelections();
        while (i.hasNext()) {
            BirthmarkSelection elem = i.next();
            if (elem.isVisible(this.isExpertMode())) {
                this.model.addElement(elem);
            }
            this.select(elem.getType(), elem.isVisible(this.isExpertMode()) && elem.isSelected());
        }
        this.updateUI();
    }

    public static class Renderer
    extends JCheckBox
    implements ListCellRenderer {
        private static final long serialVersionUID = -324432943654654L;
        private static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public Renderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean forcus) {
            BirthmarkSelection elem = (BirthmarkSelection)value;
            this.setText(elem.getService().getDisplayType());
            this.setToolTipText(elem.getService().getDescription());
            this.setSelected(elem.isSelected());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            Border border = null;
            if (forcus) {
                if (isSelected) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = noFocusBorder;
            }
            this.setBorder(border);
            return this;
        }
    }
}

