/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.ExtractionTarget;
import jp.sourceforge.stigmata.printer.ExtractionResultSetPrinter;
import jp.sourceforge.stigmata.printer.PrinterManager;
import jp.sourceforge.stigmata.spi.ResultPrinterSpi;
import jp.sourceforge.stigmata.ui.swing.BirthmarkTree;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.actions.PopupShowAction;
import jp.sourceforge.stigmata.ui.swing.actions.SaveAction;
import jp.sourceforge.stigmata.utils.AsciiDataWritable;
import jp.sourceforge.talisman.i18n.Messages;

public class BirthmarkExtractionResultPane
extends JPanel {
    private static final long serialVersionUID = 239084365756236543L;
    private StigmataFrame frame;
    private ExtractionResultSet extraction;

    public BirthmarkExtractionResultPane(StigmataFrame stigmataFrame, ExtractionResultSet ers) {
        this.frame = stigmataFrame;
        this.extraction = ers;
        this.initLayouts();
    }

    private void initLayouts() {
        Box southPanel = Box.createHorizontalBox();
        SaveAction saveAction = new SaveAction(this.frame, new AsciiDataWritable(){

            @Override
            public void writeAsciiData(PrintWriter out, String format) {
                ResultPrinterSpi service = PrinterManager.getInstance().getService(format);
                if (service == null) {
                    service = PrinterManager.getDefaultFormatService();
                }
                ExtractionResultSetPrinter list = service.getExtractionResultSetPrinter();
                list.printResult(new PrintWriter(out), BirthmarkExtractionResultPane.this.extraction);
            }
        });
        AbstractAction compareAction = new AbstractAction(){
            private static final long serialVersionUID = -1938101718384412339L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BirthmarkExtractionResultPane.this.frame.compareExtractionResult(BirthmarkExtractionResultPane.this.extraction);
            }
        };
        Messages messages = this.frame.getMessages();
        JButton saveButton = GUIUtility.createButton(messages, "savebirthmark", saveAction);
        JButton compareButton = GUIUtility.createButton(messages, "comparebirthmark", compareAction);
        JPopupMenu popup = new JPopupMenu();
        popup.add(GUIUtility.createJMenuItem(messages, "savebirthmark", saveAction));
        popup.add(GUIUtility.createJMenuItem(messages, "comparebirthmark", compareAction));
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(new BirthmarkTree(this.frame, this.extraction.getBirthmarkSets(ExtractionTarget.TARGET_BOTH)));
        this.setLayout(new BorderLayout());
        this.add(popup);
        this.add((Component)scroll, "Center");
        this.add((Component)southPanel, "South");
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(saveButton);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(compareButton);
        southPanel.add(Box.createHorizontalGlue());
        this.addMouseListener(new PopupShowAction(popup));
    }
}

