/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.result.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.BirthmarkStoreTarget;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.result.history.ExtractedBirthmarkHistory;
import jp.sourceforge.stigmata.spi.ExtractedBirthmarkSpi;

public class ExtractedBirthmarkServiceManager {
    private ExtractedBirthmarkServiceManager parent;
    private Map<BirthmarkStoreTarget, ExtractedBirthmarkSpi> targets = new HashMap<BirthmarkStoreTarget, ExtractedBirthmarkSpi>();
    private BirthmarkEnvironment env;

    public ExtractedBirthmarkServiceManager(BirthmarkEnvironment env) {
        this.env = env;
        this.parent = null;
    }

    public ExtractedBirthmarkServiceManager(BirthmarkEnvironment env, ExtractedBirthmarkServiceManager parent) {
        this(env);
        this.parent = parent;
    }

    public ExtractionResultSet createDefaultResultSet(BirthmarkContext context) {
        BirthmarkStoreTarget bst = context.getStoreTarget();
        if (bst == null) {
            String type = this.env.getProperty("birthmark.store.target");
            if (type == null) {
                type = "XMLFILE";
            }
            bst = BirthmarkStoreTarget.valueOf(type);
        }
        if (bst == null) {
            bst = BirthmarkStoreTarget.XMLFILE;
        }
        ExtractedBirthmarkSpi service = this.findService(bst);
        return service.createResultSet(context);
    }

    public ExtractedBirthmarkHistory getHistory(String id) {
        ExtractedBirthmarkHistory history = null;
        if (this.parent != null) {
            history = this.parent.getHistory(id);
        }
        if (history == null) {
            int index = id.indexOf(":");
            String type = id.substring(0, index);
            BirthmarkStoreTarget bst = BirthmarkStoreTarget.valueOf(type);
            String path = id.substring(index + 1);
            ExtractedBirthmarkSpi service = this.findService(bst);
            if (service != null) {
                history = service.getHistory(path);
            }
        }
        return history;
    }

    public synchronized String[] getHistoryIds() {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        if (this.parent != null) {
            for (String id : this.parent.getHistoryIds()) {
                values.add(id);
            }
        }
        this.addValuesFromProperty(values);
        this.addValuesFromSystemFile(values);
        char separator = File.separatorChar;
        values.add("XMLFILE:" + BirthmarkEnvironment.getStigmataHome() + separator + "extracted_birthmarks");
        return values.toArray(new String[values.size()]);
    }

    private synchronized ExtractedBirthmarkSpi findService(BirthmarkStoreTarget bst) {
        ExtractedBirthmarkSpi spi = this.targets.get(bst);
        if (spi == null) {
            this.refreshService();
        }
        spi = this.targets.get(bst);
        return spi;
    }

    private synchronized void refreshService() {
        Iterator<ExtractedBirthmarkSpi> i = this.env.lookupProviders(ExtractedBirthmarkSpi.class);
        while (i.hasNext()) {
            ExtractedBirthmarkSpi service = i.next();
            this.targets.put(service.getTarget(), service);
        }
    }

    private void addValuesFromSystemFile(Set<String> values) {
        File file = new File(BirthmarkEnvironment.getStigmataHome(), "storelocations.txt");
        if (file.exists()) {
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(file));
                while ((line = in.readLine()) != null) {
                    values.add(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addValuesFromProperty(Set<String> values) {
        String path = this.env.getProperty("extracted.birthmark.store.locations");
        if (path != null) {
            String[] paths;
            this.addValuesFromProperty(values);
            for (String p : paths = path.split(", *")) {
                values.add(p);
            }
        }
    }
}

