/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.printer.xml;

import java.io.PrintWriter;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.ComparisonPair;
import jp.sourceforge.stigmata.ComparisonPairElement;
import jp.sourceforge.stigmata.printer.AbstractComparisonPairPrinter;
import jp.sourceforge.stigmata.printer.xml.ExtractionResultSetXmlPrinter;

public class ComparisonPairXmlPrinter
extends AbstractComparisonPairPrinter {
    private ExtractionResultSetXmlPrinter list;

    public ComparisonPairXmlPrinter(ExtractionResultSetXmlPrinter list) {
        this.list = list;
    }

    @Override
    public void printResult(PrintWriter out, ComparisonPair pair) {
        this.printHeader(out);
        out.println("  <extracted-birthmarks>");
        this.list.printBirthmarkSet(out, pair.getTarget1());
        this.list.printBirthmarkSet(out, pair.getTarget2());
        out.println("  </extracted-birthmarks>");
        out.println("  <comparison-result-set>");
        this.printComparisonPair(out, pair);
        out.println("  </comparison-result-set>");
        this.printFooter(out);
    }

    @Override
    public void printHeader(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<birthmark-result-set>");
    }

    @Override
    public void printFooter(PrintWriter out) {
        out.println("</birthmark-result-set>");
        out.flush();
    }

    public void printComparisonPair(PrintWriter out, ComparisonPair pair) {
        out.println("    <comparison-result>");
        this.printTarget(out, pair.getTarget1(), 1);
        this.printTarget(out, pair.getTarget2(), 2);
        out.println("      <birthmark-similarities>");
        for (ComparisonPairElement element : pair) {
            this.printPairElement(out, element);
        }
        out.println("      </birthmark-similarities>");
        out.print("      <similarity>");
        out.print(pair.calculateSimilarity());
        out.println("</similarity>");
        out.println("    </comparison-result>");
    }

    private void printTarget(PrintWriter out, BirthmarkSet set, int index) {
        out.printf("      <target%d>%n", index);
        out.printf("        <name>%s</name>%n", this.list.escapeToXmlString(set.getName()));
        out.printf("        <location>%s</location>%n", this.list.escapeToXmlString(set.getLocation()));
        out.printf("      </target%d>%n", index);
    }

    private void printPairElement(PrintWriter out, ComparisonPairElement e) {
        out.printf("        <birthmark-similarity type=\"%s\" comparison-count=\"%d\">%g</birthmark-similarity>%n", e.getType(), e.getComparisonCount(), e.getSimilarity());
    }
}

