/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.hook;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.hook.Phase;
import jp.sourceforge.stigmata.hook.StigmataHook;
import jp.sourceforge.stigmata.hook.StigmataRuntimeHook;

public class MultipleStigmataHook
implements StigmataHook,
StigmataRuntimeHook {
    private List<StigmataHook> hooks = new ArrayList<StigmataHook>();
    private List<StigmataRuntimeHook> runtimeHooks = new ArrayList<StigmataRuntimeHook>();

    @Override
    public void onHook(Phase phase, BirthmarkContext context) {
        for (StigmataRuntimeHook hook : this.runtimeHooks) {
            if (hook == null) continue;
            hook.onHook(phase, context);
        }
    }

    @Override
    public void onHook(Phase phase, BirthmarkEnvironment env) {
        for (StigmataHook hook : this.hooks) {
            if (hook == null) continue;
            hook.onHook(phase, env);
        }
    }

    public void addHook(StigmataHook hook) {
        this.hooks.add(hook);
    }

    public void removeHook(StigmataHook hook) {
        this.hooks.remove(hook);
    }

    public int getHookCount() {
        return this.hooks.size();
    }

    public StigmataHook getHook(int index) {
        return this.hooks.get(index);
    }

    public void addRuntimeHook(StigmataRuntimeHook hook) {
        this.runtimeHooks.add(hook);
    }

    public void removeRuntimeHook(StigmataRuntimeHook hook) {
        this.runtimeHooks.remove(hook);
    }

    public int getRuntimeHookCount() {
        return this.runtimeHooks.size();
    }

    public StigmataRuntimeHook getRuntimeHook(int index) {
        return this.runtimeHooks.get(index);
    }
}

