/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.Stigmata;
import jp.sourceforge.stigmata.command.AbstractStigmataCommand;

public class InstallCommand
extends AbstractStigmataCommand {
    @Override
    public boolean isAvailableArguments(String[] args) {
        return args.length > 0;
    }

    @Override
    public String getCommandString() {
        return "install";
    }

    @Override
    public void perform(Stigmata stigmata, BirthmarkContext context, String[] args) {
        File pluginsDir = new File(BirthmarkEnvironment.getStigmataHome(), "plugins");
        BirthmarkEnvironment env = context.getEnvironment();
        for (int i = 0; i < args.length; ++i) {
            File pluginSource = new File(args[i]);
            File pluginDest = new File(pluginsDir, pluginSource.getName());
            if (!pluginSource.getName().endsWith(".jar")) {
                throw new IllegalArgumentException("plugin is allowed only jar archive: " + args[i]);
            }
            if (pluginDest.exists()) {
                String override = env.getProperty("override.exists.plugin");
                if (override != null && (override.equalsIgnoreCase("true") || override.equalsIgnoreCase("yes"))) {
                    pluginDest.delete();
                } else {
                    File backupFile = new File(pluginDest.getParent(), pluginDest.getName() + ".back");
                    if (backupFile.exists()) {
                        backupFile.delete();
                    }
                    pluginDest.renameTo(backupFile);
                }
            }
            byte[] data = new byte[256];
            try {
                int read;
                FileInputStream in = new FileInputStream(pluginSource);
                FileOutputStream out = new FileOutputStream(pluginDest);
                while ((read = ((InputStream)in).read(data)) != -1) {
                    ((OutputStream)out).write(data, 0, read);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

