/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.kgram;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.sourceforge.stigmata.birthmarks.kgram.KGram;
import jp.sourceforge.stigmata.birthmarks.kgram.KGramBasedBirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.kgram.KGramBuilder;
import jp.sourceforge.stigmata.birthmarks.kgram.OpcodeExtractionMethodVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class KGramBasedBirthmarkExtractVisitor
extends BirthmarkExtractVisitor {
    private int kvalue;
    private List<Integer> opcodes = new ArrayList<Integer>();

    public KGramBasedBirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkContext context) {
        super(visitor, birthmark, context);
    }

    public int getKValue() {
        return this.kvalue;
    }

    public void setKValue(int kvalue) {
        this.kvalue = kvalue;
    }

    @Override
    public void visitEnd() {
        KGram<Integer>[] kgrams;
        KGramBuilder builder = KGramBuilder.getInstance();
        for (KGram<Integer> kgram : kgrams = builder.buildKGram(this.opcodes, this.getKValue())) {
            this.addElement(new KGramBasedBirthmarkElement<Integer>(kgram));
        }
    }

    @Override
    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
        MethodVisitor visitor = super.visitMethod(arg0, arg1, arg2, arg3, arg4);
        OpcodeExtractionMethodVisitor opcodeVisitor = new OpcodeExtractionMethodVisitor(visitor, this.opcodes);
        return opcodeVisitor;
    }
}

