/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.comparators;

import java.util.HashSet;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.comparators.AbstractBirthmarkComparator;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

public class LogicalAndBirthmarkComparator
extends AbstractBirthmarkComparator {
    public LogicalAndBirthmarkComparator(BirthmarkSpi spi) {
        super(spi);
    }

    @Override
    public double compare(Birthmark b1, Birthmark b2, BirthmarkContext context) {
        if (!b1.getType().equals(b2.getType())) {
            return Double.NaN;
        }
        BirthmarkElement[] element1 = b1.getElements();
        BirthmarkElement[] element2 = b2.getElements();
        HashSet<BirthmarkElement> set1 = new HashSet<BirthmarkElement>();
        for (int i = 0; i < element1.length; ++i) {
            set1.add(element1[i]);
        }
        HashSet<BirthmarkElement> set2 = new HashSet<BirthmarkElement>();
        for (int i = 0; i < element2.length; ++i) {
            set2.add(element2[i]);
        }
        HashSet<BirthmarkElement> set = new HashSet<BirthmarkElement>();
        for (BirthmarkElement elem : set1) {
            if (!set2.contains(elem)) continue;
            set.add(elem);
        }
        for (BirthmarkElement elem : set2) {
            if (!set1.contains(elem)) continue;
            set.add(elem);
        }
        int len = set1.size() + set2.size();
        int frac = set.size() * 2;
        double similarity = (double)frac / (double)len;
        if (len == 0 && frac == 0) {
            similarity = 1.0;
        }
        return similarity;
    }

    @Override
    public int getCompareCount(Birthmark b1, Birthmark b2) {
        return b1.getElementCount() + b2.getElementCount();
    }
}

