/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.comparators;

import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.comparators.EditDistanceBirthmarkComparator;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

public class ExtendedEditDistanceBirthmarkComparator
extends EditDistanceBirthmarkComparator {
    public ExtendedEditDistanceBirthmarkComparator(BirthmarkSpi spi) {
        super(spi);
    }

    public double compare(Birthmark b1, Birthmark b2) {
        if (!b1.getType().equals(b2.getType())) {
            return Double.NaN;
        }
        BirthmarkElement[] element1 = b1.getElements();
        BirthmarkElement[] element2 = b2.getElements();
        int[][] distance = this.createDistanceMatrics(element1, element2);
        int length = element1.length;
        if (length > element2.length) {
            length = element2.length;
        }
        int d = distance[element1.length][element2.length];
        return (double)(1 - (d + Math.abs(element1.length - element2.length))) / (double)length;
    }
}

