/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.comparators;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.ValueCountable;
import jp.sourceforge.stigmata.birthmarks.comparators.AbstractBirthmarkComparator;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

public class CosineSimilarityBirthmarkComparator
extends AbstractBirthmarkComparator {
    public CosineSimilarityBirthmarkComparator(BirthmarkSpi spi) {
        super(spi);
    }

    @Override
    public double compare(Birthmark b1, Birthmark b2, BirthmarkContext context) {
        if (!b1.getType().equals(b2.getType())) {
            return Double.NaN;
        }
        if (b1.getElementCount() == 0 && b2.getElementCount() == 0) {
            return 1.0;
        }
        if (b1.getElementCount() == 0 || b2.getElementCount() == 0) {
            return 0.0;
        }
        HashMap<String, CountPair> pairs = new HashMap<String, CountPair>();
        this.addCount(pairs, b1, true);
        this.addCount(pairs, b2, false);
        double norm1 = this.norm(pairs, true);
        double norm2 = this.norm(pairs, false);
        double product = this.innerproduct(pairs);
        double similarity = product / (norm1 * norm2);
        return similarity;
    }

    private double innerproduct(Map<String, CountPair> pairs) {
        double sum = 0.0;
        for (CountPair pair : pairs.values()) {
            sum += (double)(pair.get(true) * pair.get(false));
        }
        return sum;
    }

    private double norm(Map<String, CountPair> pairs, boolean first) {
        double sum = 0.0;
        for (CountPair pair : pairs.values()) {
            sum += (double)(pair.get(first) * pair.get(first));
        }
        return Math.sqrt(sum);
    }

    private void addCount(Map<String, CountPair> pairs, Birthmark birthmark, boolean first) {
        for (BirthmarkElement element : birthmark) {
            ValueCountable vc = (ValueCountable)((Object)element);
            CountPair cp = pairs.get(vc.getValueName());
            if (cp == null) {
                cp = new CountPair();
                pairs.put(vc.getValueName(), cp);
            }
            cp.set(first, vc.getValueCount());
        }
    }

    private void printAll(Map<String, CountPair> pairs) {
        System.out.println("----------");
        for (Map.Entry<String, CountPair> entry : pairs.entrySet()) {
            CountPair pair = entry.getValue();
            System.out.printf("%40s: %5d, %5d%n", entry.getKey(), pair.get(true), pair.get(false));
        }
    }

    private class CountPair {
        private int c1 = 0;
        private int c2 = 0;

        private CountPair() {
        }

        public int get(boolean first) {
            if (first) {
                return this.c1;
            }
            return this.c2;
        }

        public void set(boolean first, int count) {
            if (first) {
                this.c1 = count;
            } else {
                this.c2 = count;
            }
        }
    }
}

