/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.AbstractBirthmark;
import jp.sourceforge.stigmata.birthmarks.FrequencyBirthmarkElement;
import jp.sourceforge.stigmata.utils.ArrayIterator;

public class FrequencyBirthmark
extends AbstractBirthmark {
    private static final long serialVersionUID = 1905526895627693908L;
    private Map<String, FrequencyBirthmarkElement> counts = new HashMap<String, FrequencyBirthmarkElement>();
    private String type;

    public FrequencyBirthmark(String type) {
        this.type = type;
    }

    @Override
    public int getElementCount() {
        return this.counts.size();
    }

    @Override
    public synchronized BirthmarkElement[] getElements() {
        BirthmarkElement[] elements = new FrequencyBirthmarkElement[this.counts.size()];
        int index = 0;
        for (Map.Entry<String, FrequencyBirthmarkElement> entry : this.counts.entrySet()) {
            elements[index] = entry.getValue();
            ++index;
        }
        Arrays.sort(elements, new Comparator<FrequencyBirthmarkElement>(){

            @Override
            public int compare(FrequencyBirthmarkElement o1, FrequencyBirthmarkElement o2) {
                return o1.getValueName().compareTo(o2.getValueName());
            }
        });
        return elements;
    }

    @Override
    public Iterator<BirthmarkElement> iterator() {
        return new ArrayIterator<BirthmarkElement>(this.getElements());
    }

    @Override
    public void addElement(BirthmarkElement element) {
        String value;
        if (element instanceof FrequencyBirthmarkElement) {
            FrequencyBirthmarkElement e = (FrequencyBirthmarkElement)element;
            value = e.getValueName();
        } else {
            value = (String)element.getValue();
        }
        FrequencyBirthmarkElement foundElement = this.counts.get(value);
        if (foundElement != null) {
            foundElement.incrementValueCount();
        } else {
            foundElement = new FrequencyBirthmarkElement(value);
        }
        this.counts.put(value, foundElement);
    }

    @Override
    public String getType() {
        return this.type;
    }
}

