/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkExtractionFailedException;
import jp.sourceforge.stigmata.BirthmarkExtractor;
import jp.sourceforge.stigmata.ExtractionUnit;
import jp.sourceforge.stigmata.birthmarks.PlainBirthmark;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

public abstract class AbstractBirthmarkExtractor
implements BirthmarkExtractor {
    private BirthmarkSpi spi;

    public AbstractBirthmarkExtractor() {
    }

    public AbstractBirthmarkExtractor(BirthmarkSpi spi) {
        this.spi = spi;
    }

    @Override
    public BirthmarkSpi getProvider() {
        return this.spi;
    }

    @Override
    public final Birthmark extract(InputStream in, BirthmarkContext context) throws BirthmarkExtractionFailedException {
        return this.extract(this.createBirthmark(), in, context);
    }

    @Override
    public final Birthmark extract(Birthmark birthmark, byte[] bytecode, BirthmarkContext context) throws BirthmarkExtractionFailedException {
        return this.extract(birthmark, new ByteArrayInputStream(bytecode), context);
    }

    @Override
    public final Birthmark extract(byte[] bytecode, BirthmarkContext context) throws BirthmarkExtractionFailedException {
        return this.extract(this.createBirthmark(), new ByteArrayInputStream(bytecode), context);
    }

    @Override
    public abstract Birthmark extract(Birthmark var1, InputStream var2, BirthmarkContext var3) throws BirthmarkExtractionFailedException;

    @Override
    public Birthmark createBirthmark() {
        return new PlainBirthmark(this.getProvider().getType());
    }

    @Override
    public abstract ExtractionUnit[] getAcceptableUnits();

    @Override
    public boolean isAcceptable(ExtractionUnit unit) {
        ExtractionUnit[] units = this.getAcceptableUnits();
        for (int i = 0; i < units.length; ++i) {
            if (units[i] != unit) continue;
            return true;
        }
        return false;
    }
}

