/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.ui.swing.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.MdsMethod;
import jp.sourceforge.talisman.mds.ui.swing.CurrentDirectoryHandler;
import jp.sourceforge.talisman.mds.ui.swing.MdsViewerPane;
import jp.sourceforge.talisman.mds.ui.swing.actions.ExtensionFileFilter;

public class StoreItemsAction
extends AbstractAction {
    private static final long serialVersionUID = 445562293718912259L;
    private Component parent;
    private MdsViewerPane viewer;
    private CurrentDirectoryHandler handler;

    public StoreItemsAction(MdsViewerPane viewer) {
        this(viewer, viewer, viewer);
    }

    public StoreItemsAction(Component parent, MdsViewerPane viewer) {
        this(parent, viewer, viewer);
    }

    public StoreItemsAction(Component parent, MdsViewerPane viewer, CurrentDirectoryHandler handler) {
        super(viewer.getMessages().get("store.coordinates.label"));
        this.parent = parent;
        this.viewer = viewer;
        this.handler = handler;
        if (viewer.getMessages().hasValue("store.coordinates.tooltip")) {
            this.putValue("ShortDescription", viewer.getMessages().get("store.coordinates.tooltip"));
        }
        if (viewer.getMessages().hasValue("store.coordinates.icon")) {
            Icon icon = viewer.getMessages().getIcon("store.coordinates.icon");
            this.putValue("SmallIcon", icon);
        }
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.handler.getCurrentDirectory());
        chooser.addChoosableFileFilter(new ExtensionFileFilter("csv", "CSV (Comma Separated Value)"));
        chooser.setMultiSelectionEnabled(false);
        int value = chooser.showSaveDialog(this.parent);
        if (value == 0) {
            this.handler.setCurrentDirectory(chooser.getCurrentDirectory());
            FileFilter filter = chooser.getFileFilter();
            File target = chooser.getSelectedFile();
            if (!filter.accept(target) && filter instanceof ExtensionFileFilter) {
                target = new File(target.getParentFile(), target.getName() + "." + ((ExtensionFileFilter)filter).getExtension());
            }
            try {
                this.storeCoordinates(target);
            }
            catch (IOException exception) {
                JOptionPane.showMessageDialog(this.parent, this.viewer.getMessages().get("show.error.io.message") + "\r\n" + exception.getMessage(), this.viewer.getMessages().get("show.error.dialog.title"), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCoordinates(File target) throws IOException {
        PrintWriter out = null;
        try {
            MdsMethod<?> method = this.viewer.getMdsMethod();
            out = new PrintWriter(new FileWriter(target));
            out.print(",,");
            for (int i = 0; i < method.getRank(); ++i) {
                out.print(',');
                out.print(this.viewer.getMessages().get("show.coordinate.xaxis.label"));
                out.print(i + 1);
            }
            out.println();
            Item[] items = method.getItems();
            for (int i = 0; i < items.length; ++i) {
                out.print(items[i].getName());
                out.print(',');
                out.print(items[i].getName());
                out.print(',');
                out.print(items[i].getGroupId());
                for (int j = 0; j < items[i].getDimension(); ++j) {
                    out.print(',');
                    out.print(items[i].get(j));
                }
                out.println();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

