/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.ui.mark;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import jp.sourceforge.talisman.mds.ui.mark.CircleDrawer;
import jp.sourceforge.talisman.mds.ui.mark.CrossDrawer;
import jp.sourceforge.talisman.mds.ui.mark.DownerTriangleDrawer;
import jp.sourceforge.talisman.mds.ui.mark.MarkIcon;
import jp.sourceforge.talisman.mds.ui.mark.RectangleDrawer;
import jp.sourceforge.talisman.mds.ui.mark.RhombusDrawer;
import jp.sourceforge.talisman.mds.ui.mark.StarDrawer;
import jp.sourceforge.talisman.mds.ui.mark.UpperTriangleDrawer;
import jp.sourceforge.talisman.mds.ui.mark.XMarkDrawer;
import jp.sourceforge.talisman.mds.ui.swing.GeometoryType;
import jp.sourceforge.talisman.mds.ui.swing.MarkDrawer;

public class DrawerFactory {
    private static final DrawerFactory instance = new DrawerFactory();
    private Map<GeometoryType, MarkDrawer> drawers = new LinkedHashMap<GeometoryType, MarkDrawer>();

    private DrawerFactory() {
        this.drawers.put(GeometoryType.XMARK, new XMarkDrawer());
        this.drawers.put(GeometoryType.CROSS, new CrossDrawer());
        this.drawers.put(GeometoryType.STAR, new StarDrawer());
        this.drawers.put(GeometoryType.CIRCLE, new CircleDrawer());
        this.drawers.put(GeometoryType.FILLED_CIRCLE, new CircleDrawer(true));
        this.drawers.put(GeometoryType.RHOMBUS, new RhombusDrawer());
        this.drawers.put(GeometoryType.FILLED_RHOMBUS, new RhombusDrawer(true));
        this.drawers.put(GeometoryType.RECTANGLE, new RectangleDrawer());
        this.drawers.put(GeometoryType.FILLED_RECTANGLE, new RectangleDrawer(true));
        this.drawers.put(GeometoryType.UPPER_TRIANGLE, new UpperTriangleDrawer());
        this.drawers.put(GeometoryType.FILLED_UPPER_TRIANGLE, new UpperTriangleDrawer(true));
        this.drawers.put(GeometoryType.DOWNER_TRIANGLE, new DownerTriangleDrawer());
        this.drawers.put(GeometoryType.FILLED_DOWNER_TRIANGLE, new DownerTriangleDrawer(true));
    }

    public static DrawerFactory getInstance() {
        return instance;
    }

    public MarkDrawer create(int type) {
        GeometoryType[] types = GeometoryType.values();
        if (type < types.length - 1) {
            return this.create(types[type + 1]);
        }
        return this.create(types[0]);
    }

    public MarkDrawer create(GeometoryType type) {
        return this.drawers.get((Object)type);
    }

    public Icon createIcon(int type) {
        GeometoryType[] types = GeometoryType.values();
        if (type < types.length - 1) {
            return this.createIcon(types[type + 1]);
        }
        return this.createIcon(types[0]);
    }

    public Icon createIcon(GeometoryType type) {
        return new MarkIcon(this.create(type));
    }
}

