/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.ui;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class MdsGraphSetting {
    private static final int TRANSPARENCY = 200;
    private Color foreground = Color.BLACK;
    private Color background = Color.WHITE;
    private Color gridColor = Color.DARK_GRAY;
    private Color subGridColor = Color.GRAY;
    private Color selectedAreaColor = Color.LIGHT_GRAY;
    private boolean showLabels = true;
    private boolean showGrid = true;
    private boolean showSubGrid = true;
    private boolean selectable = true;
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public MdsGraphSetting() {
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.setGridColor(Color.DARK_GRAY);
        this.setSubGridColor(Color.GRAY);
        this.setSelectedAreaColor(Color.LIGHT_GRAY);
        this.setShowLabels(true);
        this.setShowGrid(true);
        this.setShowSubGrid(true);
        this.setSelectable(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEvent(PropertyChangeEvent e) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(e);
        }
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public Color getSubGridColor() {
        return this.subGridColor;
    }

    public Color getSelectedAreaColor() {
        return this.selectedAreaColor;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public boolean isShowSubGrid() {
        return this.showSubGrid;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setGridColor(Color gridColor) {
        if (gridColor == null) {
            throw new NullPointerException();
        }
        Color oldColor = this.gridColor;
        this.gridColor = gridColor;
        this.fireEvent(new PropertyChangeEvent(this, "grid_color", oldColor, gridColor));
    }

    public void setSubGridColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        Color oldColor = this.subGridColor;
        this.subGridColor = color;
        this.fireEvent(new PropertyChangeEvent(this, "subgrid_color", oldColor, color));
    }

    public void setBackground(Color background) {
        if (background == null) {
            throw new NullPointerException();
        }
        Color oldColor = this.background;
        this.background = background;
        this.fireEvent(new PropertyChangeEvent(this, "background", oldColor, background));
    }

    public void setForeground(Color foreground) {
        if (foreground == null) {
            throw new NullPointerException();
        }
        Color oldColor = this.foreground;
        this.foreground = foreground;
        this.fireEvent(new PropertyChangeEvent(this, "foreground", oldColor, foreground));
    }

    public void setShowLabels(boolean showLabels) {
        boolean old = this.showLabels;
        this.showLabels = showLabels;
        this.fireEvent(new PropertyChangeEvent(this, "show_labels", new Boolean(old), new Boolean(showLabels)));
    }

    public void setShowGrid(boolean showGrid) {
        boolean old = this.showGrid;
        this.showGrid = showGrid;
        this.fireEvent(new PropertyChangeEvent(this, "show_grid", new Boolean(old), new Boolean(showGrid)));
    }

    public void setShowSubGrid(boolean showSubGrid) {
        boolean old = this.showSubGrid;
        this.showSubGrid = showSubGrid;
        this.fireEvent(new PropertyChangeEvent(this, "show_subgrid", new Boolean(old), new Boolean(showSubGrid)));
    }

    public void setSelectable(boolean selectable) {
        boolean old = this.selectable;
        this.selectable = selectable;
        this.fireEvent(new PropertyChangeEvent(this, "selectable", new Boolean(old), new Boolean(selectable)));
    }

    public void setSelectedAreaColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        Color old = this.selectedAreaColor;
        this.selectedAreaColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 200);
        this.fireEvent(new PropertyChangeEvent(this, "selected_area_color", old, color));
    }
}

