/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.cluster;

import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.Table;
import jp.sourceforge.talisman.mds.cluster.AbstractClusteringMethod;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.cluster.ClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.HierarchicalClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.ParameterTypeMismatchException;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceCalculator;

class LanceWilliamsClusteringMethod
extends AbstractClusteringMethod {
    public LanceWilliamsClusteringMethod(ClusteringParameter param) throws ParameterTypeMismatchException {
        super(param);
        if (!(param instanceof HierarchicalClusteringParameter)) {
            throw new ParameterTypeMismatchException("HierarchicalClusteringParameter is required");
        }
    }

    public LanceWilliamsClusteringMethod(HierarchicalClusteringParameter param) {
        super(param);
    }

    protected Cluster[] doClustering(Item[] items, ClusteringParameter parameter) {
        HierarchicalClusteringParameter param = (HierarchicalClusteringParameter)parameter;
        Cluster[] clusters = this.initClusters(items, param);
        ClusterDistanceCalculator cdc = param.getClusterDistanceCalculator();
        Table<Cluster> table = new Table<Cluster>();
        for (int i = 0; i < clusters.length; ++i) {
            for (int j = 0; j < i; ++j) {
                table.addValue(clusters[i], clusters[j], cdc.calculate(clusters[i], clusters[j]));
            }
        }
        while (table.getKeySize() > param.getNumberOfCluster()) {
            Cluster clusterI = null;
            Cluster clusterJ = null;
            double distance = Double.MAX_VALUE;
            for (Table.Entry entry : table) {
                Number value = entry.getValue();
                if (value == null || !(value.doubleValue() < distance)) continue;
                clusterI = (Cluster)entry.getX();
                clusterJ = (Cluster)entry.getY();
                distance = entry.getValue().doubleValue();
            }
            if (clusterI == null || clusterJ == null) continue;
            Cluster clusterIJ = new Cluster();
            clusterIJ.setName(clusterI.getName() + ", " + clusterJ.getName());
            for (Item item : clusterI) {
                clusterIJ.addItem(item);
            }
            for (Item item : clusterJ) {
                clusterIJ.addItem(item);
            }
            for (Cluster clusterK : table.getKeySet()) {
                if (clusterK == clusterI || clusterK == clusterJ) continue;
                table.addValue(clusterIJ, clusterK, cdc.update(clusterI, clusterJ, clusterK, table.getValue(clusterI, clusterJ).doubleValue(), table.getValue(clusterI, clusterK).doubleValue(), table.getValue(clusterJ, clusterK).doubleValue()));
            }
            table.removeRow(clusterI);
            table.removeRow(clusterJ);
            table.removeColumn(clusterI);
            table.removeColumn(clusterJ);
        }
        return table.getKeys(new Cluster[table.getKeySize()]);
    }

    private Cluster[] initClusters(Item[] items, HierarchicalClusteringParameter param) {
        Cluster[] clusters = new Cluster[items.length];
        for (int i = 0; i < items.length; ++i) {
            clusters[i] = new Cluster();
            clusters[i].setName(items[i].getName());
            clusters[i].addItem(items[i]);
        }
        return clusters;
    }
}

