package jp.naist.se.stigmata.ui.swing.actions;

/*
 * $Id: AboutAction.java 252 2007-10-24 13:08:50Z tama3 $
 */

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JPanel;

import jp.naist.se.stigmata.ui.swing.GUIUtility;
import jp.naist.se.stigmata.ui.swing.Messages;

/**
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 252 $ $Date: 2007-10-24 22:08:50 +0900 (Wed, 24 Oct 2007) $
 */
public class AboutAction extends ShowTextAction{
    private static final long serialVersionUID = -7060581883871662749L;

    public AboutAction(Component parent){
        super(parent);
    }

    @Override
    public boolean isHtmlDocument(){
        return true;
    }

    @Override
    public String getTitle(){
        return Messages.getString("about.dialog.title");
    }

    @Override
    public String getMessage(){
        String aboutMessage = loadStringFromFile(GUIUtility.getResource("about.message.file"));

        Package p = getClass().getPackage();
        aboutMessage = aboutMessage.replace("${implementation.version}", p.getImplementationVersion());
        aboutMessage = aboutMessage.replace("${implementation.vendor}",  p.getImplementationVendor());
        aboutMessage = aboutMessage.replace("${implementation.title}",   p.getImplementationTitle());

        return aboutMessage;
    }

    @Override
    protected void updatePanel(JPanel panel){
        JLabel logo = new JLabel(GUIUtility.getIcon("stigmata.logo"));
        panel.add(logo, BorderLayout.NORTH);
    }
}
