package jp.naist.se.stigmata.birthmarks.fuc;

/*
 * $Id: FrequencyUsedClassesBirthmarkService.java 233 2007-10-04 06:17:52Z tama3 $
 */

import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.birthmarks.AbstractBirthmarkService;
import jp.naist.se.stigmata.birthmarks.FrequencyBirthmarkElement;
import jp.naist.se.stigmata.birthmarks.comparators.CosineSimilarityBirthmarkComparator;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

/**
 * 
 * 
 *
 * @author Haruaki TAMADA
 * @version $Revision: 233 $ $Date: 2007-10-04 15:17:52 +0900 (Thu, 04 Oct 2007) $
 */
public class FrequencyUsedClassesBirthmarkService extends AbstractBirthmarkService implements BirthmarkSpi{
    private BirthmarkComparator comparator = new CosineSimilarityBirthmarkComparator(this);
    private BirthmarkExtractor extractor = new FrequencyUsedClassesBirthmarkExtractor(this);

    public String getType(){
        return "fuc";
    }

    public String getDefaultDescription(){
        return "Frequency of used classes in target class.";
    }

    public BirthmarkExtractor getExtractor(){
        return extractor;
    }

    public BirthmarkComparator getComparator(){
        return comparator;
    }

    public boolean isExpert(){
        return false;
    }

    public boolean isUserDefined(){
        return false;
    }

    public BirthmarkElement createBirthmarkElement(String value){
    	return new FrequencyBirthmarkElement(value);
    }
}
