package jp.naist.se.stigmata.filter;

/*
 * $Id: AbstractComparisonPairFilterService.java 140 2007-06-28 10:48:47Z tama3 $
 */

import java.util.Locale;

import jp.naist.se.stigmata.spi.AbstractServiceProvider;
import jp.naist.se.stigmata.spi.ComparisonPairFilterSpi;
import jp.naist.se.stigmata.utils.LocalizedDescriptionManager;

/**
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 140 $ $Date: 2007-06-28 19:48:47 +0900 (Thu, 28 Jun 2007) $
 */
abstract class AbstractComparisonPairFilterService extends AbstractServiceProvider implements ComparisonPairFilterSpi{
    public String getDescription(Locale locale){
        return LocalizedDescriptionManager.getInstance().getDescription(
                locale, getFilterName(), LocalizedDescriptionManager.ServiceCategory.filter
            );
    }

    public String getDisplayFilterName(){
        return getDisplayFilterName(Locale.getDefault());
    }

    public String getDisplayFilterName(Locale locale){
        return LocalizedDescriptionManager.getInstance().getDisplayType(
                locale, getFilterName(), LocalizedDescriptionManager.ServiceCategory.filter
            );
    }
}
