package jp.naist.se.stigmata;

/*
 * $Id: BirthmarkComparator.java 209 2007-09-23 13:13:59Z tama3 $
 */

/**
 * Interface for comparing given two birthmarks and calculate similarity.
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 209 $ $Date: 2007-09-23 22:13:59 +0900 (Sun, 23 Sep 2007) $
 */
public interface BirthmarkComparator {
    /**
     * compare given two birthmarks and returns calculated similarity. 
     */
    public double compare(Birthmark b1, Birthmark b2);

    /**
     * returns the number of comparison. 
     */
    public int getCompareCount(Birthmark b1, Birthmark b2);

    /**
     * returns the type of birthmarks this comparator supports. 
     */
    public String getType();
}
