package jp.naist.se.stigmata.format.xml;

/*
 * $Id: BirthmarkComparisonResultXmlFormat.java 77 2007-03-15 07:50:11Z tama3 $
 */

import java.io.PrintWriter;

import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairElement;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.format.AbstractBirthmarkComparisonResultFormat;

/**
 * 
 * 
 *
 * @author Haruaki TAMADA
 * @version $Revision: 77 $ $Date: 2007-03-15 16:50:11 +0900 (Thu, 15 Mar 2007) $
 */
public class BirthmarkComparisonResultXmlFormat extends AbstractBirthmarkComparisonResultFormat{
    private BirthmarkExtractionListXmlFormat list;

    public BirthmarkComparisonResultXmlFormat(BirthmarkExtractionListXmlFormat list){
        this.list = list;
    }

    @Override
    public void printResult(PrintWriter out, ComparisonPair pair){
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<birthmark>");
        out.println("  <extracted-birthmarks>");
        list.printBirthmarkHolder(out, pair.getTarget1());
        list.printBirthmarkHolder(out, pair.getTarget2());
        out.println("  </extracted-birthmarks>");
        out.println("  <birthmark-compare-result-set>");
        printComparisonPair(out, pair);
        out.println("  </birthmark-compare-result-set>");
        out.println("</birthmark>");
    }

    @Override
    public void printResult(PrintWriter out, ComparisonResultSet resultset){
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<birthmark>");
        out.println("  <comparison-result-set>");
        for(ComparisonPair pair: resultset){
            printComparisonPair(out, pair);
        }
        out.println("  </comparison-result-set>");
        out.println("</birthmark>");
    }

    private void printComparisonPair(PrintWriter out, ComparisonPair pair){
        out.println("    <comparison-result>");
        printTarget(out, pair.getTarget1(), 1);
        printTarget(out, pair.getTarget2(), 2);
        out.println("      <birthmark-similarities>");
        for(ComparisonPairElement element: pair){
            printPairElement(out, element);
        }
        out.println("      </birthmark-similarities>");
        out.print("      <similarity>");
        out.print(pair.calculateSimilarity());
        out.println("</similarity>");
        out.println("    </comparison-result>");
    }

    private void printTarget(PrintWriter out, BirthmarkSet holder, int index){
        out.println("      <target" + index + ">");
        out.print("        <class-name>");
        out.print(list.escapeToXmlString(holder.getClassName()));
        out.println("</class-name>");
        out.print("        <location>");
        out.print(list.escapeToXmlString(holder.getLocation()));
        out.println("</location>");
        out.println("      </target" + index + ">");

    }

    private void printPairElement(PrintWriter out, ComparisonPairElement element){
        out.print("        <birthmark-similarity type=\"");
        out.print(element.getType());
        out.print("\" comparison-count=\"");
        out.print(element.getComparisonCount());
        out.print("\">");
        out.print(element.getSimilarity());
        out.println("</birthmark-similarity>");
    }
}
