package jp.naist.se.stigmata;

/*
 * $Id: BirthmarkExtractor.java 66 2007-03-03 15:11:35Z tama3 $
 */

import java.io.InputStream;

/**
 * extract birthmarks from given Java bytecode stream.
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 66 $ $Date: 2007-03-04 00:11:35 +0900 (Sun, 04 Mar 2007) $
 */
public interface BirthmarkExtractor{
    /**
     * extract birthmark given stream.
     */
    public Birthmark extract(InputStream in) throws BirthmarkExtractionException;

    /**
     * extract birthmark given byte array.
     */
    public Birthmark extract(byte[] bytecode) throws BirthmarkExtractionException;

    /**
     * extract birthmark given stream with given context.
     */
    public Birthmark extract(InputStream in, BirthmarkContext context) throws BirthmarkExtractionException;

    /**
     * extract birthmark given byte array with given context.
     */
    public Birthmark extract(byte[] bytecode, BirthmarkContext context) throws BirthmarkExtractionException;
}
