/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.filter;

import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.filter.SimilarityComparisonPairFilter;
import jp.naist.se.stigmata.filter.SimilarityComparisonPairFilterService;
import jp.naist.se.stigmata.spi.ComparisonPairFilterSpi;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.filter.AbstractComparisonPairFilterComponentService;
import jp.naist.se.stigmata.ui.swing.filter.ComparisonPairFilterPane;

public class SimilarityComparisonPairFilterComponentService
extends AbstractComparisonPairFilterComponentService {
    public ComparisonPairFilterPane createComponent(ComparisonPairFilterSpi service) {
        return new Pane(service);
    }

    public String getFilterName() {
        return "similarity";
    }

    public ComparisonPairFilterSpi getComparisonPairFilterService() {
        return new SimilarityComparisonPairFilterService();
    }

    private static class Pane
    extends ComparisonPairFilterPane {
        private static final long serialVersionUID = 8912037614500713027L;
        private ComparisonPairFilterSpi service;
        private JComboBox criterionType;
        private JTextField threshold;

        public Pane(ComparisonPairFilterSpi service) {
            this.service = service;
            this.initLayouts();
        }

        public String[] getErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.threshold.getText().trim().equals("")) {
                errors.add(Messages.getString("error.empty.threshold"));
            }
            try {
                double v = Double.parseDouble(this.threshold.getText());
                if (v < 0.0) {
                    errors.add(Messages.getString("error.negative.value", v));
                } else if (v > 1.0) {
                    errors.add(Messages.getString("error.over.range", "0-1"));
                }
            }
            catch (NumberFormatException e) {
                errors.add(Messages.getString("error.invalid.format.double", this.threshold.getText()));
            }
            return errors.toArray(new String[errors.size()]);
        }

        public ComparisonPairFilter getFilter() {
            try {
                SimilarityComparisonPairFilter filter = new SimilarityComparisonPairFilter(this.service);
                filter.setThreshold(Double.parseDouble(this.threshold.getText()));
                filter.setCriterion(this.getCriterion((String)this.criterionType.getSelectedItem()));
                return filter;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void resetComponents() {
            this.threshold.setText("");
            this.criterionType.setSelectedIndex(0);
        }

        public void setFilter(ComparisonPairFilter filter) {
            if (filter != null) {
                SimilarityComparisonPairFilter sf = (SimilarityComparisonPairFilter)filter;
                this.criterionType.setSelectedItem(this.getDisplayCriterion(sf.getCriterion()));
                this.threshold.setText(Double.toString(sf.getThreshold()));
            } else {
                this.resetComponents();
            }
        }

        private void initLayouts() {
            JLabel label = new JLabel(Messages.getString("filter.similarity.label"));
            this.threshold = new JTextField();
            this.criterionType = this.createCriteriaBox(SimilarityComparisonPairFilter.CRITERIA);
            this.setLayout(new GridLayout(3, 1));
            this.add(label);
            this.add(this.criterionType);
            this.add(this.threshold);
            this.threshold.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                }

                public void removeUpdate(DocumentEvent e) {
                }
            });
        }
    }
}

