/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.format.csv;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.naist.se.stigmata.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairElement;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.format.AbstractBirthmarkComparisonResultFormat;
import jp.naist.se.stigmata.format.csv.BirthmarkExtractionResultCsvFormat;

public class BirthmarkComparisonResultCsvFormat
extends AbstractBirthmarkComparisonResultFormat {
    private BirthmarkExtractionResultCsvFormat list;

    public BirthmarkComparisonResultCsvFormat(BirthmarkExtractionResultCsvFormat list) {
        this.list = list;
    }

    public void printResult(PrintWriter out, ComparisonPair pair) {
        this.list.printBirthmarkHolder(out, pair.getTarget1());
        this.list.printBirthmarkHolder(out, pair.getTarget2());
        for (ComparisonPairElement element : pair) {
            out.print("compare,");
            out.print(element.getType());
            out.print(",");
            out.println(element.getSimilarity());
        }
        out.flush();
    }

    public void printResult(PrintWriter out, ComparisonResultSet resultset) {
        if (resultset instanceof CertainPairComparisonResultSet) {
            this.printResultImpl(out, (CertainPairComparisonResultSet)resultset);
        } else {
            this.printResultImpl(out, resultset);
        }
    }

    private void printResultImpl(PrintWriter out, CertainPairComparisonResultSet resultset) {
        for (ComparisonPair pair : resultset) {
            out.print(pair.getTarget1().getClassName());
            out.print(",");
            out.print(pair.getTarget1().getClassName());
            out.print(",");
            out.println(pair.calculateSimilarity());
        }
    }

    private void printResultImpl(PrintWriter out, ComparisonResultSet resultset) {
        LinkedHashMap<String, HashMap<String, Double>> map = new LinkedHashMap<String, HashMap<String, Double>>();
        ArrayList<String> names = new ArrayList<String>();
        for (ComparisonPair pair : resultset) {
            HashMap<String, Double> val = (HashMap<String, Double>)map.get(pair.getTarget1().getClassName());
            if (val == null) {
                val = new HashMap<String, Double>();
            }
            val.put(pair.getTarget2().getClassName(), new Double(pair.calculateSimilarity()));
            if (!names.contains(pair.getTarget2().getClassName())) {
                names.add(pair.getTarget2().getClassName());
            }
            map.put(pair.getTarget1().getClassName(), val);
        }
        for (String name : names) {
            out.print(",");
            out.print(name);
        }
        out.println();
        for (String key : map.keySet()) {
            Map element = (Map)map.get(key);
            out.print(key);
            for (String name : names) {
                out.print(",");
                Double v = (Double)element.get(name);
                if (v == null) continue;
                out.print(v);
            }
            out.println();
        }
        out.flush();
    }
}

