package jp.naist.se.stigmata;

/*
 * $Id: StigmataTest.java 43 2007-02-19 04:33:25Z tama3 $
 */

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import jp.naist.se.stigmata.spi.BirthmarkSpi;

/**
 * test case.
 * @author Haruaki TAMADA
 * @version $Revision: 43 $ $Date: 2007-02-19 13:33:25 +0900 (Mon, 19 Feb 2007) $
 */
public class StigmataTest{
    private BirthmarkContext context;

    @Before
    public void prepare(){
        context = Stigmata.getInstance().createContext();
    }

    @Test
    public void checkAvailableServices() throws Exception{
        Assert.assertNotNull(context.getService("smc"));
        Assert.assertNotNull(context.getService("cvfv"));
        Assert.assertNotNull(context.getService("is"));
        Assert.assertNotNull(context.getService("uc"));
    }

    @Test
    public void checkSmcBirthmarkService() throws Exception{
        BirthmarkSpi service = context.getService("smc");

        Assert.assertNotNull(service.getComparator());
        Assert.assertNotNull(service.getExtractor());
        Assert.assertEquals(
            service.getComparator().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.PlainBirthmarkComparator"
        );
        Assert.assertEquals(
            service.getExtractor().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.smc.SequentialMethodCallBirthmarkExtractor"
        );
    }

    @Test
    public void checkCvfvBirthmarkService() throws Exception{
        BirthmarkSpi service = context.getService("cvfv");

        Assert.assertNotNull(service.getComparator());
        Assert.assertNotNull(service.getExtractor());
        Assert.assertEquals(
            service.getComparator().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.PlainBirthmarkComparator"
        );
        Assert.assertEquals(
            service.getExtractor().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.cvfv.ConstantValueOfFieldVariableBirthmarkExtractor"
        );
    }

    @Test
    public void checkIsBirthmarkService() throws Exception{
        BirthmarkSpi service = context.getService("is");

        Assert.assertNotNull(service.getComparator());
        Assert.assertNotNull(service.getExtractor());
        Assert.assertEquals(
            service.getComparator().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.PlainBirthmarkComparator"
        );
        Assert.assertEquals(
            service.getExtractor().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.is.InheritanceStructureBirthmarkExtractor"
        );
    }

    @Test
    public void checkUcBirthmarkService() throws Exception{
        BirthmarkSpi service = context.getService("uc");

        Assert.assertNotNull(service.getComparator());
        Assert.assertNotNull(service.getExtractor());
        Assert.assertEquals(
            service.getComparator().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.PlainBirthmarkComparator"
        );
        Assert.assertEquals(
            service.getExtractor().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.uc.UsedClassesBirthmarkExtractor"
        );
    }
}
