/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.utils.WellknownClassJudgeRule;
import jp.naist.se.stigmata.utils.WellknownClassManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigFileParser
extends DefaultHandler {
    private BirthmarkContext context;
    private WellknownClassManager manager;
    private boolean wellknownPart = false;
    private boolean propertyPart = false;
    private boolean classpathPart = false;
    private int wellknownType = 0;
    private int patternType = 0;
    private String qname;
    private String key;

    public ConfigFileParser(BirthmarkContext context) {
        this.context = context;
        this.manager = context.getWellknownClassManager();
    }

    public void parse(InputStream in) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(in, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.qname = qName;
        if (qName.equals("wellknown-classes")) {
            this.wellknownPart = true;
            this.propertyPart = false;
            this.classpathPart = false;
        } else if (qName.equals("property")) {
            this.wellknownPart = false;
            this.propertyPart = true;
            this.classpathPart = false;
        } else if (qName.equals("classpath-list")) {
            this.wellknownPart = false;
            this.propertyPart = false;
            this.classpathPart = true;
        } else if (qName.equals("exclude")) {
            this.wellknownType = 128;
        } else if (qName.equals("package")) {
            this.wellknownType = 32;
        } else if (qName.equals("class-name")) {
            this.wellknownType = 64;
        } else if (qName.equals("fully-name")) {
            this.wellknownType = 16;
        } else if (qName.equals("suffix")) {
            this.patternType = 2;
        } else if (qName.equals("prefix")) {
            this.patternType = 1;
        } else if (qName.equals("match")) {
            this.patternType = 4;
        }
    }

    public void characters(char[] data, int offset, int length) throws SAXException {
        String value = new String(data, offset, length).trim();
        if (value.length() > 0) {
            if (this.qname.equals("name") && this.propertyPart) {
                this.key = new String(data, offset, length).trim();
            } else if (this.qname.equals("value") && this.propertyPart) {
                this.context.addProperty(this.key, new String(data, offset, length).trim());
            } else if (this.wellknownPart && (this.qname.equals("suffix") || this.qname.equals("prefix") || this.qname.equals("match"))) {
                this.manager.add(new WellknownClassJudgeRule(new String(data, offset, length), this.wellknownType | this.patternType));
            } else if (this.classpathPart && this.qname.equals("classpath")) {
                try {
                    this.context.getBytecodeContext().addClasspath(new URL(value));
                }
                catch (MalformedURLException e) {
                    throw new SAXException(e);
                }
            }
        }
    }
}

